figA1_results = xlsread('../processed_data/figureA1.xlsx');
figA1_results = figA1_results';

set(0,'defaulttextinterpreter','latex')

bfr        = [figA1_results(1,1) figA1_results(1,3) figA1_results(1,5) figA1_results(1,7)];
sefr       = [figA1_results(1,2) figA1_results(1,4) figA1_results(1,6) figA1_results(1,8)];
boffset    = [figA1_results(2,1) figA1_results(2,3) figA1_results(2,5) figA1_results(2,7)];
seoffset   = [figA1_results(2,2) figA1_results(2,4) figA1_results(2,6) figA1_results(2,8)];
binteract  = [figA1_results(3,1) figA1_results(3,3) figA1_results(3,5) figA1_results(3,7)];
seinteract = [figA1_results(3,2) figA1_results(3,4) figA1_results(3,6) figA1_results(3,8)];


x = categorical({'CQ','1Q','2Q','3Q'});
x = reordercats(x,{'CQ','1Q','2Q','3Q'});
s = {'CQ','1Q','2Q','3Q'};

conf  = 1.645;
bfrerr  = conf*sefr;
bfrlb = bfr - conf*sefr;
bfrub = bfr + conf*sefr;
boffseterr = conf*seoffset;
boffsetlb = boffset - conf*seoffset;
boffsetub = boffset + conf*seoffset;
binteracterr = conf*seinteract;
binteractlb = binteract - conf*seinteract;
binteractub = binteract + conf*seinteract;


% - Colors -
green = [0.0 0.6 0.0];
blue  = [0.0 0.0 0.6];
red   = [0.6 0.0 0.0];
myred= [0.6350 0.0780 0.1840];
myblue = [0 0.4470 0.7410];

% - Line width -
heavy = 3;
light = 0.8;

height = 11;
aspect = 16/9;

%% RGDP Results 
figure('units','centimeter','Position',[10 10 1.25*height*aspect 2.75*height],'color','w')
subplot(3,1,1)
bar(x,bfr,'FaceAlpha',0.0,'EdgeColor','none')
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold on
er = errorbar(x,bfr,bfrerr,'-s','MarkerSize',10,...
   'MarkerEdgeColor',myblue,'MarkerFaceColor',myblue);
er.Color = myblue;
er.LineStyle = 'none';  
er.LineWidth = 2;
ylabel('$\beta_1$','interpreter','latex','FontSize',16);
hold off
subplot(3,1,2)
bar(x,boffset,'FaceAlpha',0.0,'EdgeColor','none')
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold on
er = errorbar(x,boffset,boffseterr,'-s','MarkerSize',10,...
   'MarkerEdgeColor',myblue,'MarkerFaceColor',myblue);
er.Color = myblue;
er.LineStyle = 'none'; 
er.LineWidth = 2;
ylabel('$\beta_2$','interpreter','latex','FontSize',16);
hold off
subplot(3,1,3)
bar(x,binteract,'FaceAlpha',0.0,'EdgeColor','none')
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold on
er = errorbar(x,binteract,binteracterr,'-s','MarkerSize',10,...
   'MarkerEdgeColor',myblue,'MarkerFaceColor',myblue);
er.Color = myblue;
er.LineStyle = 'none';
er.LineWidth = 2;
ylabel('$\beta_3$','interpreter','latex','FontSize',16);
xlabel('Horizon','interpreter','latex','FontSize',16);
hold off
saveas(gcf,fullfile(figure_folder,'figureA1.eps'),'epsc')
