
%% Figure A1
results_NGDP    = xlsread('../processed_data/offset_reg_NGDP.xlsx');
results_PGDP    = xlsread('../processed_data/offset_reg_PGDP.xlsx');
results_RCONSUM = xlsread('../processed_data/offset_reg_RCONSUM.xlsx');
results_RFEDGOV = xlsread('../processed_data/offset_reg_RFEDGOV.xlsx');
results_RGDP    = xlsread('../processed_data/offset_reg_RGDP.xlsx');
results_RNRESIN = xlsread('../processed_data/offset_reg_RNRESIN.xlsx');
results_RRESINV = xlsread('../processed_data/offset_reg_RRESINV.xlsx');
results_RSLGOV  = xlsread('../processed_data/offset_reg_RSLGOV.xlsx');
results_TBILL   = xlsread('../processed_data/offset_reg_TBILL.xlsx');
results_TBOND   = xlsread('../processed_data/offset_reg_TBOND.xlsx');
results_URATE   = xlsread('../processed_data/offset_reg_UNEMP.xlsx');

set(0,'defaulttextinterpreter','latex')

bfr0        = [results_NGDP(1,1) results_PGDP(1,1) results_RCONSUM(1,1) results_RFEDGOV(1,1) results_RGDP(1,1) ...
    results_RNRESIN(1,1) results_RRESINV(1,1) results_RSLGOV(1,1) results_TBILL(1,1) results_TBOND(1,1) results_URATE(1,1)];
sefr0       = [results_NGDP(2,1) results_PGDP(2,1) results_RCONSUM(2,1) results_RFEDGOV(2,1) results_RGDP(2,1) ...
    results_RNRESIN(2,1) results_RRESINV(2,1) results_RSLGOV(2,1) results_TBILL(2,1) results_TBOND(2,1) results_URATE(2,1)];
boffset0    = [results_NGDP(1,2) results_PGDP(1,2) results_RCONSUM(1,2) results_RFEDGOV(1,2) results_RGDP(1,2) ...
    results_RNRESIN(1,2) results_RRESINV(1,2) results_RSLGOV(1,2) results_TBILL(1,2) results_TBOND(1,2) results_URATE(1,2)];
seoffset0   = [results_NGDP(2,2) results_PGDP(2,2) results_RCONSUM(2,2) results_RFEDGOV(2,2) results_RGDP(2,2) ...
    results_RNRESIN(2,2) results_RRESINV(2,2) results_RSLGOV(2,2) results_TBILL(2,2) results_TBOND(2,2) results_URATE(2,2)];
binteract0  = [results_NGDP(1,3) results_PGDP(1,3) results_RCONSUM(1,3) results_RFEDGOV(1,3) results_RGDP(1,3) ...
    results_RNRESIN(1,3) results_RRESINV(1,3) results_RSLGOV(1,3) results_TBILL(1,3) results_TBOND(1,3) results_URATE(1,3)];
seinteract0 = [results_NGDP(2,3) results_PGDP(2,3) results_RCONSUM(2,3) results_RFEDGOV(2,3) results_RGDP(2,3) ...
    results_RNRESIN(2,3) results_RRESINV(2,3) results_RSLGOV(2,3) results_TBILL(2,3) results_TBOND(2,3) results_URATE(2,3)];

bfr1        = [results_NGDP(3,1) results_PGDP(3,1) results_RCONSUM(3,1) results_RFEDGOV(3,1) results_RGDP(3,1) ...
    results_RNRESIN(3,1) results_RRESINV(3,1) results_RSLGOV(3,1) results_TBILL(3,1) results_TBOND(3,1) results_URATE(3,1)];
sefr1       = [results_NGDP(4,1) results_PGDP(4,1) results_RCONSUM(4,1) results_RFEDGOV(4,1) results_RGDP(4,1) ...
    results_RNRESIN(4,1) results_RRESINV(4,1) results_RSLGOV(4,1) results_TBILL(4,1) results_TBOND(4,1) results_URATE(4,1)];
boffset1    = [results_NGDP(3,2) results_PGDP(3,2) results_RCONSUM(3,2) results_RFEDGOV(3,2) results_RGDP(3,2) ...
    results_RNRESIN(3,2) results_RRESINV(3,2) results_RSLGOV(3,2) results_TBILL(3,2) results_TBOND(3,2) results_URATE(3,2)];
seoffset1   = [results_NGDP(4,2) results_PGDP(4,2) results_RCONSUM(4,2) results_RFEDGOV(4,2) results_RGDP(4,2) ...
    results_RNRESIN(4,2) results_RRESINV(4,2) results_RSLGOV(4,2) results_TBILL(4,2) results_TBOND(4,2) results_URATE(4,2)];
binteract1  = [results_NGDP(3,3) results_PGDP(3,3) results_RCONSUM(3,3) results_RFEDGOV(3,3) results_RGDP(3,3) ...
    results_RNRESIN(3,3) results_RRESINV(3,3) results_RSLGOV(3,3) results_TBILL(3,3) results_TBOND(3,3) results_URATE(3,3)];
seinteract1 = [results_NGDP(4,3) results_PGDP(4,3) results_RCONSUM(4,3) results_RFEDGOV(4,3) results_RGDP(4,3) ...
    results_RNRESIN(4,3) results_RRESINV(4,3) results_RSLGOV(4,3) results_TBILL(4,3) results_TBOND(4,3) results_URATE(4,3)];

bfr2        = [results_NGDP(5,1) results_PGDP(5,1) results_RCONSUM(5,1) results_RFEDGOV(5,1) results_RGDP(5,1) ...
    results_RNRESIN(5,1) results_RRESINV(5,1) results_RSLGOV(5,1) results_TBILL(5,1) results_TBOND(5,1) results_URATE(5,1)];
sefr2       = [results_NGDP(6,1) results_PGDP(6,1) results_RCONSUM(6,1) results_RFEDGOV(6,1) results_RGDP(6,1) ...
    results_RNRESIN(6,1) results_RRESINV(6,1) results_RSLGOV(6,1) results_TBILL(6,1) results_TBOND(6,1) results_URATE(6,1)];
boffset2    = [results_NGDP(5,2) results_PGDP(5,2) results_RCONSUM(5,2) results_RFEDGOV(5,2) results_RGDP(5,2) ...
    results_RNRESIN(5,2) results_RRESINV(5,2) results_RSLGOV(5,2) results_TBILL(5,2) results_TBOND(5,2) results_URATE(5,2)];
seoffset2   = [results_NGDP(6,2) results_PGDP(6,2) results_RCONSUM(6,2) results_RFEDGOV(6,2) results_RGDP(6,2) ...
    results_RNRESIN(6,2) results_RRESINV(6,2) results_RSLGOV(6,2) results_TBILL(6,2) results_TBOND(6,2) results_URATE(6,2)];
binteract2  = [results_NGDP(5,3) results_PGDP(5,3) results_RCONSUM(5,3) results_RFEDGOV(5,3) results_RGDP(5,3) ...
    results_RNRESIN(5,3) results_RRESINV(5,3) results_RSLGOV(5,3) results_TBILL(5,3) results_TBOND(5,3) results_URATE(5,3)];
seinteract2 = [results_NGDP(6,3) results_PGDP(6,3) results_RCONSUM(6,3) results_RFEDGOV(6,3) results_RGDP(6,3) ...
    results_RNRESIN(6,3) results_RRESINV(6,3) results_RSLGOV(6,3) results_TBILL(6,3) results_TBOND(6,3) results_URATE(6,3)];

bfr3        = [results_NGDP(7,1) results_PGDP(7,1) results_RCONSUM(7,1) results_RFEDGOV(7,1) results_RGDP(7,1) ...
    results_RNRESIN(7,1) results_RRESINV(7,1) results_RSLGOV(7,1) results_TBILL(7,1) results_TBOND(7,1) results_URATE(7,1)];
sefr3       = [results_NGDP(8,1) results_PGDP(8,1) results_RCONSUM(8,1) results_RFEDGOV(8,1) results_RGDP(8,1) ...
    results_RNRESIN(8,1) results_RRESINV(8,1) results_RSLGOV(8,1) results_TBILL(8,1) results_TBOND(8,1) results_URATE(8,1)];
boffset3    = [results_NGDP(7,2) results_PGDP(7,2) results_RCONSUM(7,2) results_RFEDGOV(7,2) results_RGDP(7,2) ...
    results_RNRESIN(7,2) results_RRESINV(7,2) results_RSLGOV(7,2) results_TBILL(7,2) results_TBOND(7,2) results_URATE(7,2)];
seoffset3   = [results_NGDP(8,2) results_PGDP(8,2) results_RCONSUM(8,2) results_RFEDGOV(8,2) results_RGDP(8,2) ...
    results_RNRESIN(8,2) results_RRESINV(8,2) results_RSLGOV(8,2) results_TBILL(8,2) results_TBOND(8,2) results_URATE(8,2)];
binteract3  = [results_NGDP(7,3) results_PGDP(7,3) results_RCONSUM(7,3) results_RFEDGOV(7,3) results_RGDP(7,3) ...
    results_RNRESIN(7,3) results_RRESINV(7,3) results_RSLGOV(7,3) results_TBILL(7,3) results_TBOND(7,3) results_URATE(7,3)];
seinteract3 = [results_NGDP(8,3) results_PGDP(8,3) results_RCONSUM(8,3) results_RFEDGOV(8,3) results_RGDP(8,3) ...
    results_RNRESIN(8,3) results_RRESINV(8,3) results_RSLGOV(8,3) results_TBILL(8,3) results_TBOND(8,3) results_URATE(8,3)];


x = categorical({'NGDP','PGDP','RCONS','RFED','RGDP','RNRES','RRES','RSL','TBILL','TBOND','UE'});
s = {'NGDP','PGDP','RCONS','RFED','RGDP','RNRES','RRES','RSL','TBILL','TBOND','UE'};

conf          = 1.645;
bfr0err       = conf*sefr0;
boffset0err   = conf*seoffset0;
binteract0err = conf*seinteract0;

bfr1err       = conf*sefr1;
boffset1err   = conf*seoffset1;
binteract1err = conf*seinteract1;

bfr2err       = conf*sefr2;
boffset2err   = conf*seoffset2;
binteract2err = conf*seinteract2;

bfr3err       = conf*sefr3;
boffset3err   = conf*seoffset3;
binteract3err = conf*seinteract3;

% - Colors -
green = [0.0 0.6 0.0];
blue  = [0.0 0.0 0.6];
red   = [0.6 0.0 0.0];
myred= [0.6350 0.0780 0.1840];
myblue = [0 0.4470 0.7410];

% - Line width -
heavy = 3;
light = 0.8;

height = 11;
aspect = 16/9;

%% CQ Results 
figure('units','centimeter','Position',[10 10 1.25*height*aspect 2.75*height],'color','w')
subplot(3,1,1)
bar(x,bfr0,'FaceAlpha',0.0,'EdgeColor','none')
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold on
er = errorbar(x,bfr0,bfr0err,'-s','MarkerSize',10,...
   'MarkerEdgeColor',myblue,'MarkerFaceColor',myblue);
er.Color = myblue;                 
er.LineStyle = 'none';  
er.LineWidth = 2;
ylabel('$\beta_1$','interpreter','latex','FontSize',16);
hold off
subplot(3,1,2)
bar(x,boffset0,'FaceAlpha',0.0,'EdgeColor','none')
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold on
er = errorbar(x,boffset0,boffset0err,'-s','MarkerSize',10,...
   'MarkerEdgeColor',myblue,'MarkerFaceColor',myblue);
er.Color = myblue;           
er.LineStyle = 'none'; 
er.LineWidth = 2;
ylabel('$\beta_2$','interpreter','latex','FontSize',16);
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold off
subplot(3,1,3)
bar(x,binteract0,'FaceAlpha',0.0,'EdgeColor','none')
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold on
er = errorbar(x,binteract0,binteract0err,'-s','MarkerSize',10,...
   'MarkerEdgeColor',myblue,'MarkerFaceColor',myblue);
er.Color = myblue;       
er.LineStyle = 'none';
er.LineWidth = 2;
ylabel('$\beta_3$','interpreter','latex','FontSize',16);
xlabel('Macroeconomic variable','interpreter','latex','FontSize',16);
hold off
saveas(gcf,fullfile(figure_folder,'figureA2.eps'),'epsc')

%% 1Q ahead Results 
figure('units','centimeter','Position',[10 10 1.25*height*aspect 2.75*height],'color','w')
subplot(3,1,1)
bar(x,bfr1,'FaceAlpha',0.0,'EdgeColor','none')
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold on
er = errorbar(x,bfr1,bfr1err,'-s','MarkerSize',10,...
   'MarkerEdgeColor',myblue,'MarkerFaceColor',myblue);
er.Color = myblue;                   
er.LineStyle = 'none';  
er.LineWidth = 2;
ylabel('$\beta_1$','interpreter','latex','FontSize',16);
hold off
subplot(3,1,2)
bar(x,boffset1,'FaceAlpha',0.0,'EdgeColor','none')
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold on
er = errorbar(x,boffset1,boffset1err,'-s','MarkerSize',10,...
   'MarkerEdgeColor',myblue,'MarkerFaceColor',myblue);
er.Color = myblue;           
er.LineStyle = 'none'; 
er.LineWidth = 2;
ylabel('$\beta_2$','interpreter','latex','FontSize',16);
hold off
subplot(3,1,3)
bar(x,binteract1,'FaceAlpha',0.0,'EdgeColor','none')
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold on
er = errorbar(x,binteract1,binteract1err,'-s','MarkerSize',10,...
   'MarkerEdgeColor',myblue,'MarkerFaceColor',myblue);
er.Color = myblue;       
er.LineStyle = 'none';
er.LineWidth = 2;
ylabel('$\beta_3$','interpreter','latex','FontSize',16);
xlabel('Macroeconomic variable','interpreter','latex','FontSize',16);
hold off
saveas(gcf,fullfile(figure_folder,'figureA3.eps'),'epsc')

%% 2Q ahead Results 
figure('units','centimeter','Position',[10 10 1.25*height*aspect 2.75*height],'color','w')
subplot(3,1,1)
bar(x,bfr2,'FaceAlpha',0.0,'EdgeColor','none')
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold on
er = errorbar(x,bfr2,bfr2err,'-s','MarkerSize',10,...
   'MarkerEdgeColor',myblue,'MarkerFaceColor',myblue);
er.Color = myblue;                   
er.LineStyle = 'none';  
er.LineWidth = 2;
ylabel('$\beta_1$','interpreter','latex','FontSize',16);
hold off
subplot(3,1,2)
bar(x,boffset2,'FaceAlpha',0.0,'EdgeColor','none')
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold on
er = errorbar(x,boffset2,boffset2err,'-s','MarkerSize',10,...
   'MarkerEdgeColor',myblue,'MarkerFaceColor',myblue);
er.Color = myblue;           
er.LineStyle = 'none'; 
er.LineWidth = 2;
ylabel('$\beta_2$','interpreter','latex','FontSize',16);
hold off
subplot(3,1,3)
bar(x,binteract2,'FaceAlpha',0.0,'EdgeColor','none')
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold on
er = errorbar(x,binteract2,binteract2err,'-s','MarkerSize',10,...
   'MarkerEdgeColor',myblue,'MarkerFaceColor',myblue);
er.Color = myblue;       
er.LineStyle = 'none';
er.LineWidth = 2;
ylabel('$\beta_3$','interpreter','latex','FontSize',16);
xlabel('Macroeconomic variable','interpreter','latex','FontSize',16);
hold off
saveas(gcf,fullfile(figure_folder,'figureA4.eps'),'epsc')


%% 3Q ahead Results 
figure('units','centimeter','Position',[10 10 1.25*height*aspect 2.75*height],'color','w')
subplot(3,1,1)
bar(x,bfr3,'FaceAlpha',0.0,'EdgeColor','none')
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold on
er = errorbar(x,bfr3,bfr3err,'-s','MarkerSize',10,...
   'MarkerEdgeColor',myblue,'MarkerFaceColor',myblue);
er.Color = myblue;                   
er.LineStyle = 'none';  
er.LineWidth = 2;
ylabel('$\beta_1$','interpreter','latex','FontSize',16);
hold off
subplot(3,1,2)
bar(x,boffset3,'FaceAlpha',0.0,'EdgeColor','none')
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold on
er = errorbar(x,boffset3,boffset3err,'-s','MarkerSize',10,...
   'MarkerEdgeColor',myblue,'MarkerFaceColor',myblue);
er.Color = myblue;           
er.LineStyle = 'none'; 
er.LineWidth = 2;
ylabel('$\beta_2$','interpreter','latex','FontSize',16);
hold off
subplot(3,1,3)
bar(x,binteract3,'FaceAlpha',0.0,'EdgeColor','none')
set(gca,'TickLabelInterpreter','latex','FontSize',16);
hold on
er = errorbar(x,binteract3,binteract3err,'-s','MarkerSize',10,...
   'MarkerEdgeColor',myblue,'MarkerFaceColor',myblue);
er.Color = myblue;       
er.LineStyle = 'none';
er.LineWidth = 2;
ylabel('$\beta_3$','interpreter','latex','FontSize',16);
xlabel('Macroeconomic variable','interpreter','latex','FontSize',16);
hold off
saveas(gcf,fullfile(figure_folder,'figureA5.eps'),'epsc')
