cd "/Users/julioortiz/Dropbox/OES/replication/"
use empirics/processed_data/spf_sample_final.dta, clear


* ------------------- Table 1
foreach x of varlist fr1qqar_w fr2qqar_w fr3qqar_w {
	gen `x'_L1 = l1.`x'
}

gen rgdp_yy_L3 = l3.rgdp_yy

label var fe0qqar_w "Error"
label var fe1qqar_w "Error"
label var fe2qqar_w "Error"
label var feyoy_w   "Error"

label var fr0qqar_w "Revision"
label var fr1qqar_w "Revision"
label var fr2qqar_w "Revision"
label var fryoy_w   "Revision"

label var fr1qqar_w_L1 "Previous revision"
label var fr2qqar_w_L1 "Previous revision"
label var fr3qqar_w_L1 "Previous revision"

label var rgdp_yy_L3 "Realization"

eststo clear
eststo reg1a: reghdfe fe0qqar_w  fr0qqar_w   if flag_annual==0 & flag_age==0, noa cluster(id date)
estadd scalar forecasters = e(N_clust)
eststo reg1b: reghdfe fe1qqar_w  fr1qqar_w   if flag_annual==0 & flag_age==0, noa cluster(id date)
estadd scalar forecasters = e(N_clust)
eststo reg1c: reghdfe fe2qqar_w  fr2qqar_w   if flag_annual==0 & flag_age==0, noa cluster(id date)
estadd scalar forecasters = e(N_clust)
eststo reg1d: reghdfe fr0qqar_w fr1qqar_w_L1 if flag_annual==0 & flag_age==0, noa cluster(id date)
estadd scalar forecasters = e(N_clust)
eststo reg1e: reghdfe fr1qqar_w fr2qqar_w_L1 if flag_annual==0 & flag_age==0, noa cluster(id date)
estadd scalar forecasters = e(N_clust)
eststo reg1f: reghdfe fr2qqar_w fr3qqar_w_L1 if flag_annual==0 & flag_age==0, noa cluster(id date)
estadd scalar forecasters = e(N_clust)
eststo reg1g: reghdfe feyoy_w fryoy_w if date<=yq(2016,1) & flag_age==0, noa cluster(id date)
estadd scalar forecasters = e(N_clust)
eststo reg1h: reghdfe feyoy_w rgdp_yy_L3 if date>=yq(1970,4) & date<=yq(2019,4) & flag_age==0, noa cluster(id date)
estadd scalar forecasters = e(N_clust)
esttab reg1a reg1d reg1b reg1e reg1c reg1f reg1g reg1h using "tables_and_figures/table1.tex", ///
se replace label star(* 0.10 ** 0.05 *** 0.01) s(forecasters N,label("Forecasters" "Observations")) rename(fr0qqar_w "Revision" fr1qqar_w "Revision" fr2qqar_w "Revision" fryoy_w "Revision" ///
fr1qqar_w_L1 "Previous revision" fr2qqar_w_L1 "Previous revision" fr3qqar_w_L1 "Previous revision") drop(_cons) nonotes prehead( ///
"\begin{table}[htbp]" ///
"\caption{Overreaction Among Individual Forecasters}" ///
"\label(tab:table1}" ///
"\begin{center}" ///
"\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" ///
"\scalebox{0.85}{\begin{tabular}{lcccccccc} \\" ///
"\hline\hline" ///
"\rule{0pt}{3ex}" ///
"& \multicolumn{2}{c}{Current quarter} & \multicolumn{2}{c}{One quarter ahead} & \multicolumn{2}{c}{Two quarters ahead} & \multicolumn{2}{c}{Year-over-year} \\" ///
"\cmidrule{2-3} & \cmidrule{4-5} & \cmidrule{6-7} & \cmidrule{8-9}") ///
postfoot( ///
"\hline\hline" ///
"\end{tabular}" ///
"\end{center}" ///
"\footnotesize{Note: The table reports panel regression results from SPF forecasts of real GDP growth based on regressions \eqref{eq:eq1}, \eqref{eq:eq2}, and \eqref{eq:eq3}." ///
"Standard errors clustered by forecaster and time are reported in parentheses. *** denotes 1\% significance, ** denotes 5\% significance, and * denotes 10\% significance.}" ///
"\end{table}")
