cd "/Users/julioortiz/Dropbox/OES/replication/"
use empirics/processed_data/spf_sample_final.dta, clear

gen frq1     = .
replace frq1 = fr0qqar_w if quarter==1
replace frq1 = l.fe0qqar_w if quarter==2
replace frq1 = . if quarter==3
replace frq1 = . if quarter==4

gen frq2     = .
replace frq2 = fr1qqar_w if quarter==1
replace frq2 = fr0qqar_w if quarter==2
replace frq2 = l.fe0qqar_w if quarter==3
replace frq2 = . if quarter==4

gen frq3     = .
replace frq3 = fr2qqar_w if quarter==1
replace frq3 = fr1qqar_w if quarter==2
replace frq3 = fr0qqar_w if quarter==3
replace frq3 = l.fe0qqar_w if quarter==4

gen frq4     = .
replace frq4 = fr3qqar_w if quarter==1
replace frq4 = fr2qqar_w if quarter==2
replace frq4 = fr1qqar_w if quarter==3
replace frq4 = fr0qqar_w if quarter==4


gen act_q1 = .
replace act_q1 = act_rt if quarter==1
bysort year: egen act_q1_tmp = max(act_q1)

gen act_q2 = .
replace act_q2 = act_rt if quarter==2
bysort year: egen act_q2_tmp = max(act_q2)

gen act_q3 = .
replace act_q3 = act_rt if quarter==3
bysort year: egen act_q3_tmp = max(act_q3)

gen act_q4 = .
replace act_q4 = act_rt if quarter==4
bysort year: egen act_q4_tmp = max(act_q4)

label var frq4 "Fourth quarter revision"
label var frq3 "Third quarter revision"
label var frq2 "Second quarter revision"
label var frq1 "First quarter revision"

* ------------------- Table 4
eststo clear
eststo reg1a: reghdfe frq4 frq3 frq2 frq1 , noa cluster(id date)
estadd scalar forecasters = e(N_clust)
estadd local fixedeffects = "None"
eststo reg1b: reghdfe frq4 frq3 frq2 frq1 , a(id) cluster(id date)
estadd scalar forecasters = e(N_clust)
estadd local fixedeffects = "Forecaster"
eststo reg1c: reghdfe frq4 frq3 frq2 frq1 , a(id date) cluster(id date)
estadd scalar forecasters = e(N_clust)
estadd local fixedeffects = "Forecaster, Time"

import excel using empirics/raw_data/realizations.xlsx, firstrow clear
keep if macrovar=="RGDP"
drop macrovar act_rev
drop if year<1981 & year>2019
reshape wide act_rt, i(year) j(quarter)
tsset year
label var act_rt4 "Fourth quarter growth"
label var act_rt3 "Third quarter growth"
label var act_rt2 "Second quarter growth"
label var act_rt1 "First quarter growth"
eststo reg1d: newey2 act_rt4 act_rt3 act_rt2 act_rt1 if year>=1981 & year<=2019, nocons lag(3)
estadd local fixedeffects = "None"

esttab reg1a reg1b reg1c reg1d using "tables_and_figures/table4.tex", ///
se replace label star(* 0.10 ** 0.05 *** 0.01) s(fixedeffects forecasters N,label("Fixed effects" "Forecasters" "Observations")) drop(_cons) nonotes prehead( ///
"\begin{table}[htbp]" ///
"\caption{Offsetting Real GDP Revisions Within Calendar Year}" ///
"\label(tab:table4}" ///
"\begin{center}" ///
"\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" ///
"\scalebox{0.85}{\begin{tabular}{lcccccccc} \\" ///
"\hline\hline" ///
"\rule{0pt}{3ex}") ///
postfoot( ///
"\hline\hline" ///
"\end{tabular}" ///
"\end{center}" ///
"\footnotesize{Note: The table reports panel regression results from SPF forecasts of real GDP growth based on regressions \eqref{eq:reg3a}. Standard errors for regressions in columns (1) through (3) are clustered by forecaster and time and are reported in parentheses. Newey-West standard errors are specified for time series regression in column (4). *** denotes 1\% significance, ** denotes 5\% significance, and * denotes 10\% significance.}" ///
"\end{table}")
