
clear all
set scheme cleanplots
set more off
cd "/Users/julioortiz/Dropbox/OES/replication"

** Annual data

insheet using empirics/raw_data/RGDPactualsyoy.csv, comma clear
rename year year_vintage
gen year = year_vintage -1 
tsset year 
rename yoy annual_growth
keep year annual_growth
gen lannual_growth = l.annual_growth
save empirics/processed_data/RGDPactualsannual.dta, replace

insheet using empirics/raw_data/RGDPlastyear.csv, comma clear
gen date_vintage = yq(year,quarter)
format date_vintage %tq
rename date_vintage date
format date %tq
keep date levelly
tsset date
save empirics/processed_data/RGDPactualslastyearannual.dta, replace

insheet using empirics/raw_data/Annualprediction.csv, comma clear
gen date = yq(year,quarter)
format date %tq
rename fc annual_forecast
keep date id annual_forecast
save empirics/processed_data/Annualprediction.dta, replace


**************************************************************************************************
use empirics/processed_data/datindiv, clear
drop if year>2019
keep if macrovar=="RGDP"

gen error=0
replace error=1 if date==yq(1985,1) | date==yq(1986,1) | date==yq(1990,1)
gen gdpgnp=0
replace gdpgnp=1 if date==yq(1992,1)
gen chwgt=0
replace chwgt=1 if date==yq(1996,1)
gen basechg=0
replace basechg=1 if date==yq(1976,1) | date==yq(1986,1) | date==yq(1992,1) | date==yq(1996,1) | date==yq(1999,4) | date==yq(2004,1) | date==yq(2009,3) | date==yq(2013,3) | date==yq(2018,3)
gen smallsample=0
replace smallsample=1 if date==yq(1990,2)
gen flags=0
replace flags=1 if error==1|gdpgnp==1|smallsample==1|basechg==1

gen flag_annual = 0
replace flag_annual = 1 if date<yq(1981,3)

merge 1:1 id date using empirics/processed_data/Annualprediction.dta
keep if _merge==3
drop _merge 
merge m:1 year using empirics/processed_data/RGDPactualsannual.dta, nogen

xtset id date

foreach x of varlist h1 h2 h3 h4 h5 h6 hA hB {

gen `x'_w = `x'
summ `x', d
replace `x'_w = . if `x'< (r(p50)-5*(r(p75)-r(p25))) | `x'> (r(p50) + 5*(r(p75)-r(p25)))

}
replace annual_forecast =. if hA==.

gen fe0y = annual_growth - annual_forecast
gen f1y = (hB_w/hA_w -1)*100 
gen fr0y = .
replace fr0y = annual_forecast - l.annual_forecast if quarter>1
replace fr0y = annual_forecast - l.f1y if quarter==1

gen fe0qqar = act_rt - ((h2_w/h1_w)^4-1)*100
gen lfe0qqar = l.fe0qqar 

bysort id (date): gen agemax=_N
gen flag_age = 0
replace flag_age = 1 if agemax<10

* -------------- Report Table A2 Summary Statistics --------- *
putexcel set tables_and_figures/tableA2.xlsx, replace
putexcel A1="Variable" B1="Mean" C1="Median" D1="Std.Dev" E1="P25" F1="P75"

summ annual_forecast if flag_annual==0 & flags==0 & flag_age==0, d
putexcel A2="Current-year forecast" B2=`r(mean)' C2=`r(p50)' D2=`r(sd)' E2=`r(p25)' F2=`r(p75)'
summ fe0y if flag_annual==0 & flags==0 & flag_age==0, d
putexcel A3="Current-year error" B3=`r(mean)' C3=`r(p50)' D3=`r(sd)' E3=`r(p25)' F3=`r(p75)'
summ fr0y if flag_annual==0 & flags==0 & flag_age==0, d
putexcel A4="Current-year revision" B4=`r(mean)' C4=`r(p50)' D4=`r(sd)' E4=`r(p25)' F4=`r(p75)'
summ annual_growth if flag_annual==0 & flags==0 & flag_age==0, d
putexcel A5="Current-year real-time outcome" B5=`r(mean)' C5=`r(p50)' D5=`r(sd)' E5=`r(p25)' F5=`r(p75)'

*------------------------------------------------------------ *


