clear all
set more off
set scheme cleanplots


* Bringing in Bloomberg forecasts
import excel using empirics/raw_data/BBG_forecasts.xlsx, sh("Sheet1") firstrow clear

drop Exactdate Date
gen year=substr(string(Exactm),1,4)
gen mon=substr(string(Exactm),5,6)
destring year mon, replace
gen date=ym(year,mon)
format date %tm
gen quarter=1
replace quarter=2 if mon==4| mon==5| mon==6
replace quarter=3 if mon==7| mon==8| mon==9
replace quarter=4 if mon==10| mon==11| mon==12
gen dateq=yq(year,quarter)
format dateq %tq
order date dateq, first
drop N1Y REC PY HL
rename mon month
destring, replace

replace H1="" if H1=="n/a"
	replace H1="" if H1=="na"
replace H3="" if H3=="n/a"
	drop if H3=="c"
replace H4="" if H4=="n/a"	
	replace H4="" if H4=="na"
destring, replace

egen id=group(Bank)
rename date datem
rename dateq date

sort id datem date
bysort id date: gen obs=_n
keep if month==3|month==6|month==9|month==12
drop if obs>1
xtset id date

rename H0 GDPCQ
rename H1 GDP1Q
rename H2 GDP2Q
rename H3 GDP3Q
rename H4 GDP4Q
rename CY GDPCY
rename NY GDP1Y

foreach x of varlist GDPCQ GDP1Q GDP2Q GDP3Q GDP4Q GDPCY GDP1Y {

gen `x'_w = `x'
summ `x', d
replace `x'_w = . if (`x'< (r(p50)-5*(r(p75)-r(p25))) | `x'> (r(p50) + 5*(r(p75)-r(p25))))

}

xtset id date

* Bring in year-over-year growth
cap drop _merge
merge m:1 date using empirics/raw_data/rgdp_yy.dta
xtset id date
keep if _merge==3

* Bring in actual annual
cap drop _merge
merge m:1 year using empirics/processed_data/RGDPactualsannual.dta
keep if _merge==3
xtset id date

* Now bring in q/q a.r. actuals 
cap drop _merge
merge m:1 year quarter using empirics/raw_data/realizations_RGDP.dta
keep if _merge==3
drop _merge
xtset id date

* forecast
gen f0qq = ((1+GDPCQ/100)^0.25-1)*100
gen f1qq = ((1+GDP1Q/100)^0.25-1)*100
gen f2qq = ((1+GDP2Q/100)^0.25-1)*100
gen f3qq = ((1+GDP3Q/100)^0.25-1)*100
gen f4qq = ((1+GDP4Q/100)^0.25-1)*100
gen fyoy   = ((1+f0qq/100)*(1+f1qq/100)*(1+f2qq/100)*(1+f3qq/100)-1)*100
gen fyoyp1 = ((1+f1qq/100)*(1+f2qq/100)*(1+f3qq/100)*(1+f4qq/100)-1)*100

* revision
gen fryoy = fyoy - l.fyoyp1
gen fr0y  = d.GDPCY
replace fr0y = GDPCY - l.GDP1Y if quarter==1

* error
gen feyoy = f3.rgdp_yy - fyoy
gen fe0y  = annual_growth - GDPCY

gen rgdp_yy_L1 = l1.rgdp_yy
gen annual_growth_L1 = l1.annual_growth
label var feyoy   "Error"
label var fryoy   "Revision"
label var rgdp_yy_L1 "Realization"
label var fe0y "Annual error"
label var fr0y "Annual revision"
label var annual_growth_L1 "Annual realization"

eststo clear
eststo reg1a: reghdfe feyoy fryoy, a(id) cluster(id date)
estadd local forecasters = "33"
eststo reg1b: reghdfe feyoy rgdp_yy_L1, a(id) cluster(id date)
estadd local forecasters = "39"
eststo reg1c: reghdfe fe0y annual_growth_L1, a(id) cluster(id date)
estadd local forecasters = "62"
eststo reg1d: reghdfe fe0y fr0y, a(id) cluster(id date)
estadd local forecasters = "57"
esttab reg1a reg1b reg1c reg1d using "tables_and_figures/tableA9_A10_BBG.tex", ///
se replace label star(* 0.10 ** 0.05 *** 0.01) s(forecasters N,label("Forecasters" "Observations")) drop(_cons) nonotes prehead( ///
"\begin{table}[htbp]" ///
"\caption{BBG Survey}" ///
"\label(tab:tableA9_A10_BBG}" ///
"\begin{center}" ///
"\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" ///
"\scalebox{0.85}{\begin{tabular}{lcccccccc} \\" ///
"\hline\hline" ///
"\rule{0pt}{3ex}") ///
postfoot( ///
"\hline\hline" ///
"\end{tabular}" ///
"\end{center}" ///
"\end{table}")


