clear all
set more off
set scheme cleanplots


* Bringing in WSJ data
import excel using "empirics/raw_data/WSJ_forecasts.xlsx", firstrow clear

rename A id
gen quarter=1
replace quarter=2 if month==4 
replace quarter=2 if month==5
replace quarter=2 if month==6

replace quarter=3 if month==7 
replace quarter=3 if month==8
replace quarter=3 if month==9

replace quarter=4 if month==10 
replace quarter=4 if month==11
replace quarter=4 if month==12

order year quarter month, first

replace GDPLQ="" if GDPLQ=="NA"
replace GDPCQ="" if GDPCQ=="NA"
replace GDP1Q="" if GDP1Q=="NA"
replace GDP2Q="" if GDP2Q=="NA"
replace GDP3Q="" if GDP3Q=="NA"
replace GDP4Q="" if GDP4Q=="NA"
replace GDPCY="" if GDPCY=="NA"
destring, replace


collapse (first) GDPCQ GDP1Q GDP2Q GDP3Q GDP4Q GDPCY, by(Name year quarter)

gen date=yq(year,quarter)
format date %tq
encode Name, gen(name)
egen id=group(name)

drop if year>2019

foreach x of varlist GDPCQ GDP1Q GDP2Q GDP3Q GDP4Q GDPCY {

gen `x'_w = `x'
summ `x', d
replace `x'_w = . if (`x'< (r(p50)-5*(r(p75)-r(p25))) | `x'> (r(p50) + 5*(r(p75)-r(p25))))

}

xtset id date

* Bring in year-over-year growth
cap drop _merge
merge m:1 date using empirics/raw_data/rgdp_yy.dta
xtset id date
keep if _merge==3

* Bring in actual annual
cap drop _merge
merge m:1 year using empirics/processed_data/RGDPactualsannual.dta
keep if _merge==3
xtset id date

* Now bring in q/q a.r. actuals 
cap drop _merge
merge m:1 year quarter using empirics/raw_data/realizations_RGDP.dta
keep if _merge==3
drop _merge
xtset id date

* forecast
gen f0qq = ((1+GDPCQ/100)^0.25-1)*100
gen f1qq = ((1+GDP1Q/100)^0.25-1)*100
gen f2qq = ((1+GDP2Q/100)^0.25-1)*100
gen f3qq = ((1+GDP3Q/100)^0.25-1)*100
gen f4qq = ((1+GDP4Q/100)^0.25-1)*100
gen fyoy   = ((1+f0qq/100)*(1+f1qq/100)*(1+f2qq/100)*(1+f3qq/100)-1)*100
gen fyoyp1 = ((1+f1qq/100)*(1+f2qq/100)*(1+f3qq/100)*(1+f4qq/100)-1)*100

* revision
gen fryoy = fyoy - l.fyoyp1
gen fr0y  = d.GDPCY
replace fr0y =. if quarter==1

* error
gen feyoy = f3.rgdp_yy - fyoy
gen fe0y  = annual_growth - GDPCY


reghdfe feyoy fryoy, a(id) cluster(id date)
reghdfe feyoy l.rgdp_yy, a(id) cluster(id date)

*annual regressions
reghdfe fe0y l.annual_growth, a(id) cluster(id date)
reghdfe fe0y fr0y, a(id) cluster(id date)



gen rgdp_yy_L1 = l1.rgdp_yy
gen annual_growth_L1 = l1.annual_growth
label var feyoy   "Error"
label var fryoy   "Revision"
label var rgdp_yy_L1 "Realization"
label var fe0y "Annual error"
label var fr0y "Annual revision"
label var annual_growth_L1 "Annual realization"

eststo clear
eststo reg1a: reghdfe feyoy fryoy, a(id) cluster(id date)
estadd local forecasters = "84"
eststo reg1b: reghdfe feyoy rgdp_yy_L1, a(id) cluster(id date)
estadd local forecasters = "132"
eststo reg1c: reghdfe fe0y annual_growth_L1, a(id) cluster(id date)
estadd local forecasters = "148"
eststo reg1d: reghdfe fe0y fr0y, a(id) cluster(id date)
estadd local forecasters = "144"
esttab reg1a reg1b reg1c reg1d using "tables_and_figures/tableA9_A10_WSJ.tex", ///
se replace label star(* 0.10 ** 0.05 *** 0.01) s(forecasters N,label("Forecasters" "Observations")) drop(_cons) nonotes prehead( ///
"\begin{table}[htbp]" ///
"\caption{WSJ Survey}" ///
"\label(tab:tableA9_10_WSJ}" ///
"\begin{center}" ///
"\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" ///
"\scalebox{0.85}{\begin{tabular}{lcccccccc} \\" ///
"\hline\hline" ///
"\rule{0pt}{3ex}") ///
postfoot( ///
"\hline\hline" ///
"\end{tabular}" ///
"\end{center}" ///
"\end{table}")


