Ndata=141;
S=200;

datamomvec    = zeros(10,1);
datamomvec(1) = 3.08465;
datamomvec(2) = 1.35315;
datamomvec(3) = 1.25521;
datamomvec(4) = 2.54147;
datamomvec(5) = 0.370018;
datamomvec(6) = 3.07079;
datamomvec(7) = 2.962625;
datamomvec(8) = 1.224991;
datamomvec(9) = 3.02269;
datamomvec(10)= -0.784446;


datcovmat = importdata('datcovmat_DE.txt');
datcovmat = datcovmat(1:10,1:10);
datcovmat = datcovmat*Ndata;

nmom = length(datamomvec);
npar = 7;


opt = {'CommentStyle','%', 'CollectOutput',true};
[fid,msg] = fopen('param_est_DE_uncon.txt','rt');
assert(fid>=3,msg)
C = textscan(fid, '%f', opt{:});
fclose(fid);
params = C{1};
PARAMHAT_uncon = params;

%% Figure 4
Nsim=200;
N=141;
T=244;
burn=50;

% Draw shocks
shocks=[];
rng(5301);
v=randn(Nsim,N,T);%private signal noise
e=randn(Nsim,T+burn);%public signal noise
w=randn(Nsim,T+burn);%state innovations
%for probabilties, draw U[0,1] and compare to (p,q)
pdraw=rand(Nsim,N,T);
qdraw=rand(Nsim,N,T);

nontarget_uncon=NaN(Nsim,3);
xval_uncon=PARAMHAT_uncon;
for simct=1:Nsim
    shocks.v                 = squeeze(v(simct,:,:));
    shocks.e                 = squeeze(e(simct,:));
    shocks.w                 = squeeze(w(simct,:));
    shocks.pdraw             = squeeze(pdraw(simct,:,:));
    shocks.qdraw             = squeeze(qdraw(simct,:,:));
    nontarget_uncon(simct,:) = SMM_model_DE_uncon_nontarget(xval_uncon,shocks,N,T,burn);
end

% Counterfactual: Unconstrained with theta=0
nontarget_uncon_noDE = NaN(Nsim,3);
xval_uncon_noDE      = PARAMHAT_uncon;
xval_uncon_noDE(7)   = 0;
for simct=1:Nsim
    shocks.v                      = squeeze(v(simct,:,:));
    shocks.e                      = squeeze(e(simct,:));
    shocks.w                      = squeeze(w(simct,:));
    shocks.pdraw                  = squeeze(pdraw(simct,:,:));
    shocks.qdraw                  = squeeze(qdraw(simct,:,:));
    nontarget_uncon_noDE(simct,:) = SMM_model_DE_uncon_nontarget(xval_uncon_noDE,shocks,N,T,burn);
end

% - Colors -
green  = [0.0 0.6 0.0];
blue   = [0.0 0.0 0.6];
red    = [0.6 0.0 0.0];
myred  = [0.6350 0.0780 0.1840];
myblue = [0 0.4470 0.7410];

% - Line width -
heavy  = 3;
light  = 0.8;

height = 11;
aspect = 16/9;

X = categorical({'Errors on revisions','Revision autocorrelation', 'Error on outcomes'});
X = reordercats(X,{'Errors on revisions','Revision autocorrelation', 'Error on outcomes'});

Y_uncon      = mean(nontarget_uncon);
Y_uncon_noDE = mean(nontarget_uncon_noDE);


%% Figure 4
Y_p  = Y_uncon-Y_uncon_noDE;
Y    = [Y_uncon_noDE;Y_p];
figure('units','centimeter','Position',[10 10 1.75*height*aspect 1.75*height],'color','w')
hold on;
xlim([0 0.22]);
b1=bar(X,Y,'stacked','BarWidth',0.9);
set(gca,'FontSize',16,'TickLabelInterpreter', 'latex','ycolor','k');
set(b1,{'FaceColor'},{[0.64,0.08,0.18];[0.00,0.45,0.74]},{'FaceAlpha'},{0.3});
ylabel('Percent','interpreter','latex')
legend(b1,'Annual smoothing','Diagnostic expectations', 'interpreter','latex','Location','southeast');
legend boxoff;
saveas(gcf,fullfile(figure_folder,'figure4.eps'),'epsc');

