Ndata=141;
S=200;

%% Read in results
%read in estimated parameters
opt = {'CommentStyle','%', 'CollectOutput',true};
[fid,msg] = fopen('param_est.txt','rt');
assert(fid>=3,msg)
C = textscan(fid, '%f', opt{:});
fclose(fid);
params = C{1};
PARAMHAT = params;

% Simulate non-targeted moments
Nsim=200;
N=141;
T=244;
burn=50;

% Draw shocks
shocks=[];
rng(5301);
v=randn(Nsim,N,T);%private signal noise
e=randn(Nsim,T+burn);%public signal noise
w=randn(Nsim,T+burn);%state innovations
%for probabilties, draw U[0,1] and compare to (p,q)
pdraw=rand(Nsim,N,T);
qdraw=rand(Nsim,N,T);

nontarget=NaN(Nsim,23);
kvec=NaN(Nsim,2);
xval=PARAMHAT;
for simct=1:Nsim
    shocks.v                            = squeeze(v(simct,:,:));
    shocks.e                            = squeeze(e(simct,:));
    shocks.w                            = squeeze(w(simct,:));
    shocks.pdraw                        = squeeze(pdraw(simct,:,:));
    shocks.qdraw                        = squeeze(qdraw(simct,:,:));
    [nontarget(simct,:), kvec(simct,:)] = SMM_nontarget(xval,shocks,N,T,burn);
end

mean_nontarget = mean(nontarget);
std_nontarget  = std(nontarget);


%% Table D1

mom_nontarget_description = ["b(FECQ,FRCQ)","b(FE1Q,FR1Q)","b(FE2Q,FR2Q)","b(FE3Q,FR3Q)","b(FRCQ,FR1Q_{-1})" ...
    "b(FR1Q,FR2Q_{-1})","b(FR2Q,FR3Q_{-1})","b(FEYY,FRYY)","b(FEYY,Outcome)","b(FECQ,FECQ_{-1})"]';

nontarget_table_c1 = round(mean_nontarget(11:20),3)';
nontarget_table_c2 = round(std_nontarget(11:20),3)';
nontarget_table_c3 = [0.354;0.676;0.694;-0.464;0.401;0.448;0.135;0.648;-0.077;0.084];
nontarget_table_c4 = [0.178;0.314;0.374;0.222;0.112;0.134;0.109;0.275;0.064;0.074];


disp('%%%%%%%%%%%%%%%%%%')
disp('Table D1')
disp('Model v Data Mom')
disp([mom_nontarget_description nontarget_table_c1 nontarget_table_c2 nontarget_table_c3 nontarget_table_c4])
disp(' ')
