function mom = SMM_model_moments_8199(xval,datamomvec)

Nsim=100;%number of simulations
N=84;%number of forecasters 
T=44;%number of (reference) periods 
burn=20;%burn-in length

% Draw shocks
shocks=[];
rng(5301);
v=randn(Nsim,N,T);%private signal noise
e=randn(Nsim,T+burn);%public signal noise
w=randn(Nsim,T+burn);%state innovations

%for probabilties, draw U[0,1] and compare to (p,q)
pdraw=rand(Nsim,N,T);
qdraw=rand(Nsim,N,T);
    
momvec=NaN(Nsim,size(datamomvec,1));
for simct=1:Nsim
    shocks.v = squeeze(v(simct,:,:));
    shocks.e = squeeze(e(simct,:));
    shocks.w = squeeze(w(simct,:));
    shocks.pdraw = squeeze(pdraw(simct,:,:));
    shocks.qdraw = squeeze(qdraw(simct,:,:));
    momvec(simct,:) = SMM_model(xval,shocks,datamomvec,N,T,burn);
end

mom=mean(momvec);

end