clear all
set scheme cleanplots
set more off

use empirics/processed_data/datindiv, clear
drop if year>2019

* Flags
gen error=0
replace error=1 if date==yq(1985,1) | date==yq(1986,1) | date==yq(1990,1)
gen gdpgnp=0
replace gdpgnp=1 if date==yq(1992,1)
gen chwgt=0
replace chwgt=1 if date==yq(1996,1)
gen basechg=0
replace basechg=1 if date==yq(1976,1) | date==yq(1986,1) | date==yq(1992,1) | date==yq(1996,1) | date==yq(1999,4) | date==yq(2004,1) | date==yq(2009,3) | date==yq(2013,3) | date==yq(2018,3)
gen smallsample=0
replace smallsample=1 if date==yq(1990,2)
gen flags=0
replace flags=1 if error==1|gdpgnp==1|smallsample==1|basechg==1

xtset id2 date

gen levelvar = 0
replace levelvar = 1 if macrovar == "NGDP"|macrovar=="RGDP"|macrovar=="PGDP"|macrovar=="RRESINV"|macrovar=="RFEDGOV"|macrovar=="RSLGOV"|macrovar=="RCONSUM"|macrovar=="RNRESIN"|macrovar=="INDPROD"|macrovar=="EMP"|macrovar=="HOUSING"

local varlist NGDP PGDP RCONSUM  RFEDGOV RGDP RNRESIN RRESINV RSLGOV TBILL TBOND UNEMP

foreach y of local varlist {

preserve

keep if macrovar == "`y'"


foreach x of varlist h1 h2 h3 h4 h5 h6 hA hB {

gen `x'_w = `x'
summ `x', d
replace `x'_w = . if (`x'< (r(p50)-5*(r(p75)-r(p25))) | `x'> (r(p50) + 5*(r(p75)-r(p25))))

}

xtset id2 date

gen actqq = ((1+act_rt/100)^0.25-1)*100

gen f4qqar_w= .
gen f4qq_w=.
	replace f4qqar_w = ((h6_w/h5_w)^4-1)*100 if levelvar==1
	replace f4qqar_w = h6_w if levelvar==0
	replace f4qq_w   = ((1+f4qqar_w/100)^0.25-1)*100
	
gen f3qqar_w = .
gen f3qq_w   =.
	replace f3qqar_w = ((h5_w/h4_w)^4-1)*100 if levelvar==1
	replace f3qqar_w = h5_w if levelvar==0
	replace f3qq_w   =((1+f3qqar_w/100)^0.25-1)*100
	
gen f2qqar_w =.
gen f2qq_w   =.
	replace f2qqar_w = ((h4_w/h3_w)^4-1)*100 if levelvar==1
	replace f2qqar_w = h4_w if levelvar==0
	replace f2qq_w   = ((1+f2qqar_w/100)^0.25-1)*100
	
gen f1qqar_w =.
gen f1qq_w =.
	replace f1qqar_w = ((h3_w/h2_w)^4-1)*100 if levelvar==1
	replace f1qqar_w = h3_w if levelvar==0
	replace f1qq_w   = ((1+f1qqar_w/100)^0.25-1)*100
	
gen f0qqar_w = .
gen f0qq_w   =.
	replace f0qqar_w = ((h2_w/h1_w)^4-1)*100 if levelvar==1
	replace f0qqar_w = h2_w if levelvar==0
	replace f0qq_w   = ((1+f0qqar_w/100)^0.25-1)*100

gen fr3qqar_w = f3qqar_w - l.f4qqar_w
gen fr2qqar_w = f2qqar_w - l.f3qqar_w
gen fr1qqar_w = f1qqar_w - l.f2qqar_w
gen fr0qqar_w = f0qqar_w - l.f1qqar_w

gen fr3qq = f3qq_w - l.f4qq_w
gen fr2qq = f2qq_w - l.f3qq_w
gen fr1qq = f1qq_w - l.f2qq_w
gen fr0qq = f0qq_w - l.f1qq_w

gen fe0qqar_w =    act_rt - f0qqar_w
gen fe1qqar_w =  f.act_rt - f1qqar_w
gen fe2qqar_w = f2.act_rt - f2qqar_w
gen fe3qqar_w = f3.act_rt - f3qqar_w

bysort id macrovar (date): gen agemax=_N
gen flag_age = 0
replace flag_age = 1 if agemax<10
xtset id date

gen flag_annual = 0
replace flag_annual = 1 if date<yq(1981,3)

gen offset=1
replace offset=0 if (fr0qqar_w>=0 & fr1qqar_w>=0 & fr2qqar_w>=0 & fr3qqar_w>=0) | (fr0qqar_w<=0 & fr1qqar_w<=0 & fr2qqar_w<=0 & fr3qqar_w<=0)

* ------------------- Figure A2, A3, A4, and A5

putexcel set empirics/processed_data/offset_reg_`y', replace 
loc row = 1

* ------------ Check for FE vs. FR offsetting ------------ *
reghdfe fe0qqar_w fr0qqar_w i.offset c.fr0qqar_w#i.offset if flag_annual==0 & flag_age==0 & flags==0, noa cluster(id date)

putexcel A`row' = _b[fr0qqar_w] B`row'=_b[1.offset]  C`row'=_b[c.fr0qqar_w#1.offset] 
loc row=`row'+1
putexcel A`row' = _se[fr0qqar_w] B`row'=_se[1.offset]  C`row'=_se[c.fr0qqar_w#1.offset] 
loc row=`row'+1

reghdfe fe1qqar_w fr1qqar_w i.offset c.fr1qqar_w#i.offset if flag_annual==0 & flag_age==0 & flags==0, noa cluster(id date)
putexcel A`row' = _b[fr1qqar_w] B`row'=_b[1.offset]  C`row'=_b[c.fr1qqar_w#1.offset] 
loc row=`row'+1
putexcel A`row' = _se[fr1qqar_w] B`row'=_se[1.offset]  C`row'=_se[c.fr1qqar_w#1.offset] 
loc row=`row'+1

reghdfe fe2qqar_w fr2qqar_w i.offset c.fr2qqar_w#i.offset if flag_annual==0 & flag_age==0 & flags==0, noa cluster(id date)
putexcel A`row' = _b[fr2qqar_w] B`row'=_b[1.offset]  C`row'=_b[c.fr2qqar_w#1.offset] 
loc row=`row'+1
putexcel A`row' = _se[fr2qqar_w] B`row'=_se[1.offset]  C`row'=_se[c.fr2qqar_w#1.offset] 
loc row=`row'+1

reghdfe fe3qqar_w fr3qqar_w i.offset c.fr3qqar_w#i.offset if flag_annual==0 & flag_age==0 & flags==0, noa cluster(id date)
putexcel A`row' = _b[fr3qqar_w] B`row'=_b[1.offset]  C`row'=_b[c.fr3qqar_w#1.offset] 
loc row=`row'+1
putexcel A`row' = _se[fr3qqar_w] B`row'=_se[1.offset]  C`row'=_se[c.fr3qqar_w#1.offset] 
loc row=`row'+1

restore

}
