
clear all
set scheme cleanplots
set more off
cd "/Users/julioortiz/Dropbox/OES/replication"


* Annual data
insheet using empirics/raw_data/RGDPactualsyoy.csv, comma clear
rename year year_vintage
gen year = year_vintage -1 
tsset year 
rename yoy annual_growth
keep year annual_growth
gen lannual_growth = l.annual_growth
save empirics/processed_data/RGDPactualsannual.dta, replace

insheet using empirics/raw_data/RGDPlastyear.csv, comma clear
gen date_vintage = yq(year,quarter)
format date_vintage %tq
rename date_vintage date
format date %tq
keep date levelly
tsset date
save empirics/processed_data/RGDPactualslastyearannual.dta, replace

insheet using empirics/raw_data/Annualprediction.csv, comma clear
gen date = yq(year,quarter)
format date %tq
rename fc annual_forecast
keep date id annual_forecast
save empirics/processed_data/Annualprediction.dta, replace


**************************************************************************************************
use empirics/processed_data/datindiv, clear
drop if year>2019
keep if macrovar=="RGDP" 

gen error=0
replace error=1 if date==yq(1985,1) | date==yq(1986,1) | date==yq(1990,1)
gen gdpgnp=0
replace gdpgnp=1 if date==yq(1992,1)
gen chwgt=0
replace chwgt=1 if date==yq(1996,1)
gen basechg=0
replace basechg=1 if date==yq(1976,1) | date==yq(1986,1) | date==yq(1992,1) | date==yq(1996,1) | date==yq(1999,4) | date==yq(2004,1) | date==yq(2009,3) | date==yq(2013,3) | date==yq(2018,3)
gen lbasechg=l4.basechg
gen smallsample=0
replace smallsample=1 if date==yq(1990,2)
gen flags=0
replace flags=1 if error==1|gdpgnp==1|smallsample==1|basechg==1|lbasechg==1

gen flag_annual = 0
replace flag_annual = 1 if date<yq(1981,3)

merge 1:1 id date using empirics/processed_data/Annualprediction.dta
keep if _merge==3
drop _merge 
merge m:1 year using empirics/processed_data/RGDPactualsannual.dta, nogen

xtset id date

foreach x of varlist h1 h2 h3 h4 h5 h6 hA hB {

gen `x'_w = `x'
summ `x', d
replace `x'_w = . if `x'< (r(p50)-5*(r(p75)-r(p25))) | `x'> (r(p50) + 5*(r(p75)-r(p25)))

}
replace annual_forecast =. if hA==.

gen fe0y = annual_growth - annual_forecast
gen f1y = (hB_w/hA_w -1)*100 
gen fr0y = .
replace fr0y = annual_forecast - l.annual_forecast if quarter>1
replace fr0y = annual_forecast - l.f1y if quarter==1

gen fe0qqar = act_rt - ((h2_w/h1_w)^4-1)*100
gen lfe0qqar = l.fe0qqar 

bysort id (date): gen agemax=_N
gen flag_age = 0
replace flag_age = 1 if agemax<10

gen f4qqar_w= .
gen f4qq_w=.
	replace f4qqar_w = ((h6_w/h5_w)^4-1)*100 
	
gen f3qqar_w = .
gen f3qq_w   =.
	replace f3qqar_w = ((h5_w/h4_w)^4-1)*100 
	
gen f2qqar_w =.
gen f2qq_w   =.
	replace f2qqar_w = ((h4_w/h3_w)^4-1)*100 
	
gen f1qqar_w =.
gen f1qq_w =.
	replace f1qqar_w = ((h3_w/h2_w)^4-1)*100
	
gen f0qqar_w = .
gen f0qq_w   =.
	replace f0qqar_w = ((h2_w/h1_w)^4-1)*100 

gen fr3qqar_w = f3qqar_w - l.f4qqar_w
gen fr2qqar_w = f2qqar_w - l.f3qqar_w
gen fr1qqar_w = f1qqar_w - l.f2qqar_w
gen fr0qqar_w = f0qqar_w - l.f1qqar_w

gen fr3qq = f3qq_w - l.f4qq_w
gen fr2qq = f2qq_w - l.f3qq_w
gen fr1qq = f1qq_w - l.f2qq_w
gen fr0qq = f0qq_w - l.f1qq_w

gen fe0qqar_w =    act_rt - f0qqar_w
gen fe1qqar_w =  f.act_rt - f1qqar_w
gen fe2qqar_w = f2.act_rt - f2qqar_w
gen fe3qqar_w = f3.act_rt - f3qqar_w


* -------------------- Table 2
label var fe0y "Annual error"
label var fr0y "Annual revision"
label var lannual_growth "Annual realization"
label var lfe0qqar "Realized quarterly error"

eststo clear
eststo reg1a: reghdfe fe0y fr0y if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
estadd scalar forecasters = e(N_clust)
eststo reg1b: reghdfe fe0y lannual_growth if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
estadd scalar forecasters = e(N_clust)
esttab reg1a reg1b using "tables_and_figures/table2.tex", ///
se replace label star(* 0.10 ** 0.05 *** 0.01) s(forecasters N,label("Forecasters" "Observations")) drop(_cons) nonotes prehead( ///
"\begin{table}[htbp]" ///
"\caption{No Annual Overreaction Among Individual Forecasters}" ///
"\label(tab:table2}" ///
"\begin{center}" ///
"\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" ///
"\scalebox{1}{\begin{tabular}{lcccccccc} \\" ///
"\hline\hline" ///
"\rule{0pt}{3ex}" ///
"& (1) & (2) \\" ///
"& Annual error & Annual error") ///
postfoot( ///
"\hline\hline" ///
"\end{tabular}" ///
"\end{center}" ///
"\footnotesize{Note: The table reports panel regression results from SPF forecasts of real GDP growth based on regressions \eqref{eq:eq1} and \eqref{eq:eq3}." ///
"Standard errors clustered by forecaster and time are reported in parentheses. *** denotes 1\% significance, ** denotes 5\% significance, and * denotes 10\% significance.}" ///
"\end{table}")


* -------------------- Table 3
eststo clear
eststo reg1a: reghdfe fe0y lfe0qqar if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
estadd scalar forecasters = e(N_clust)
eststo reg1b: reghdfe fe0y lfe0qqar if flag_annual==0 & flags==0 & flag_age==0, a(id) cluster(id date)
// eststo reg1b: reghdfe fe0y lfe0qqar if flag_annual==0 & error==0 & gdpgnp==0 & flag_age==0, a(id) cluster(id date)
estadd scalar forecasters = e(N_clust)
esttab reg1a reg1b using "tables_and_figures/table3.tex", ///
se replace label star(* 0.10 ** 0.05 *** 0.01) s(forecasters N,label("Forecasters" "Observations")) drop(_cons) nonotes prehead( ///
"\begin{table}[htbp]" ///
"\caption{Underreaction to Realized Quarterly Error}" ///
"\label(tab:table3}" ///
"\begin{center}" ///
"\def\sym#1{\ifmmode^{#1}\else\(^{#1}\)\fi}" ///
"\scalebox{1}{\begin{tabular}{lcccccccc} \\" ///
"\hline\hline" ///
"\rule{0pt}{3ex}" ///
"& (1) & (2) \\" ///
"& Annual error & Annual error") ///
postfoot( ///
"\hline\hline" ///
"\end{tabular}" ///
"\end{center}" ///
"\footnotesize{Note: The table reports panel regression results from SPF forecasts of real GDP growth based on regression \eqref{eq:eq4}." ///
"Standard errors clustered by forecaster and time are reported in parentheses. *** denotes 1\% significance, ** denotes 5\% significance, and * denotes 10\% significance.}" ///
"\end{table}")
