
putexcel set tables_and_figures/tableA6, replace 
putexcel A1 ="Variable" B1="Estimate" C1="Std. error" D1="Forecasters" E1="Obs."

putexcel set tables_and_figures/tableA7, replace 
putexcel A1 ="Variable" B1="Estimate" C1="Std. error" D1="Forecasters" E1="Obs."

putexcel set tables_and_figures/tableA8, replace 
putexcel A1 ="Variable" B1="Estimate" C1="Std. error" D1="Forecasters" E1="Obs."

**************************************************************************************************
* 									Unemployment rate
**************************************************************************************************
insheet using empirics/raw_data/UNEactualsyoy.csv, comma clear
rename year year_vintage
gen year = year_vintage -1 
tsset year 
rename ly annual_growth
keep year annual_growth
gen lannual_growth = l.annual_growth
save empirics/processed_data/UNEactualsannual.dta, replace

use empirics/processed_data/datindiv, clear
keep if macrovar=="UNEMP"

gen error=0
replace error=1 if date==yq(1985,1) | date==yq(1986,1) | date==yq(1990,1)
gen smallsample=0
replace smallsample=1 if date==yq(1990,2)
gen flags=0
replace flags=1 if error==1|smallsample==1
merge m:1 year using empirics/processed_data/UNEactualsannual.dta, nogen
xtset id date
foreach x of varlist h1 h2 hA hB {
	gen `x'_w = `x'
	summ `x', d
	replace `x'_w = . if `x'< (r(p50)-4*(r(p75)-r(p25))) | `x'> (r(p50) + 4*(r(p75)-r(p25)))
}
gen annual_forecast = hA
gen fe0y 			= annual_growth - annual_forecast
gen f1y 			= hB
gen fr0y2 			= annual_forecast - l4.f1y
gen fr0y 			= .
replace fr0y 		= annual_forecast - l.annual_forecast if quarter>1
replace fr0y 		= annual_forecast - l.f1y if quarter==1

gen f4qqar   = h6
gen f3qqar   = h5
gen f2qqar   = h4
gen f1qqar   = h3
gen f0qqar   = h2
gen fr3qqar  = f3qqar - l.f4qqar
gen fr2qqar  = f2qqar - l.f3qqar
gen fr1qqar  = f1qqar - l.f2qqar
gen fr0qqar  = f0qqar - l.f1qqar
gen fe0qqar  = act_rt - f0qqar
gen lfe0qqar = l.fe0qqar
gen fe1qqar  = f.act_rt - f1qqar
gen fe2qqar  = f2.act_rt - f2qqar
gen fe3qqar  = f3.act_rt - f3qqar

gen flag_annual     = 0
replace flag_annual = 1 if date<yq(1981,3)

drop if date>yq(2019,4)

bysort id (date): gen agemax = _N
gen flag_age     = 0
replace flag_age = 1 if agemax<10

putexcel set tables_and_figures/tableA6.xlsx, modify
reghdfe fe0y fr0y if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A2 = "Unemployment rate" B2=_b[fr0y] C2=_se[fr0y] D2=`e(N_clust)' E2=`e(N)'

putexcel set tables_and_figures/tableA7.xlsx, modify
reghdfe fe0y lannual_growth if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A2 = "Unemployment rate" B2=_b[lannual_growth] C2=_se[lannual_growth] D2=`e(N_clust)' E2=`e(N)'

putexcel set tables_and_figures/tableA8.xlsx, modify
reghdfe fe0y lfe0qqar if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A2 = "Unemployment rate" B2=_b[lfe0qqar] C2=_se[lfe0qqar] D2=`e(N_clust)' E2=`e(N)'


**************************************************************************************************
* 									TBILL
**************************************************************************************************
use empirics/processed_data/datindiv, clear
keep if macrovar=="TBILL"
drop if date>yq(2019,4)

preserve
collapse (last) act_rt, by(year quarter)
collapse (mean) act_rt, by(year)
tsset year
rename act_rt annual_growth
gen lannual_growth = l.annual_growth
save empirics/processed_data/TBILL_annual.dta, replace
restore

merge m:1 year using empirics/processed_data/TBILL_annual.dta 
xtset id date
gen error=0
replace error=1 if date==yq(1985,1) | date==yq(1986,1) | date==yq(1990,1)
gen smallsample=0
replace smallsample=1 if date==yq(1990,2)
gen flags=0
replace flags=1 if error==1|smallsample==1

xtset id date

foreach x of varlist h1 h2 hA hB {
	gen `x'_w = `x'
	summ `x', d
	replace `x'_w = . if `x'< (r(p50)-5*(r(p75)-r(p25))) | `x'> (r(p50) + 5*(r(p75)-r(p25)))
}
gen annual_forecast = hA_w
gen fe0y 			= annual_growth - annual_forecast
gen f1y 			= hB_w
gen fr0y 			= .
replace fr0y 		= annual_forecast - l.annual_forecast if quarter>1
replace fr0y 		= annual_forecast - l.f1y if quarter==1
gen f0qqar  		= h2_w
gen fe0qqar 		= act_rt - f0qqar
gen lfe0qqar 		= l.fe0qqar

gen flag_annual     = 0
replace flag_annual = 1 if date<yq(1981,3)

bysort id (date): gen agemax = _N
gen flag_age     = 0
replace flag_age = 1 if agemax<10

putexcel set tables_and_figures/tableA6.xlsx, modify
reghdfe fe0y fr0y if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A3 = "3-month Treasury bill" B3=_b[fr0y] C3=_se[fr0y] D3=`e(N_clust)' E3=`e(N)'

putexcel set tables_and_figures/tableA7.xlsx, modify
reghdfe fe0y lannual_growth if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A3 = "3-month Treasury bill" B3=_b[lannual_growth] C3=_se[lannual_growth] D3=`e(N_clust)' E3=`e(N)'

putexcel set tables_and_figures/tableA8.xlsx, modify
reghdfe fe0y lfe0qqar if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A3 = "3-month Treasury bill" B3=_b[lfe0qqar] C3=_se[lfe0qqar] D3=`e(N_clust)' E3=`e(N)'

**************************************************************************************************
* 									TBOND
**************************************************************************************************
use empirics/processed_data/datindiv, clear
keep if macrovar=="TBOND"
drop if date>yq(2019,4)

preserve
collapse (last) act_rt, by(year quarter)
collapse (mean) act_rt, by(year)
tsset year
rename act_rt annual_growth
gen lannual_growth = l.annual_growth
save empirics/processed_data/TBOND_annual.dta, replace
restore
merge m:1 year using empirics/processed_data/TBOND_annual.dta 
xtset id date
gen error=0
replace error=1 if date==yq(1985,1) | date==yq(1986,1) | date==yq(1990,1)
gen smallsample=0
replace smallsample=1 if date==yq(1990,2)
gen flags=0
replace flags=1 if error==1|smallsample==1

xtset id date

foreach x of varlist h1 h2 hA hB {
	gen `x'_w = `x'
	summ `x', d
	replace `x'_w = . if `x'< (r(p50)-5*(r(p75)-r(p25))) | `x'> (r(p50) + 5*(r(p75)-r(p25)))
}
gen annual_forecast = hA_w
gen fe0y 			= annual_growth - annual_forecast
gen f1y 			= hB_w
gen fr0y 			= .
replace fr0y 		= annual_forecast - l.annual_forecast if quarter>1
replace fr0y 		= annual_forecast - l.f1y if quarter==1
gen f0qqar  		= h2_w
gen fe0qqar 		= act_rt - f0qqar
gen lfe0qqar 		= l.fe0qqar

gen flag_annual     = 0
replace flag_annual = 1 if date<yq(1981,3)

bysort id (date): gen agemax = _N
gen flag_age     = 0
replace flag_age = 1 if agemax<10

putexcel set tables_and_figures/tableA6.xlsx, modify
reghdfe fe0y fr0y if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A4 = "10-year bond" B4=_b[fr0y] C4=_se[fr0y] D4=`e(N_clust)' E4=`e(N)'

putexcel set tables_and_figures/tableA7.xlsx, modify
reghdfe fe0y lannual_growth if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A4 = "10-year bond" B4=_b[lannual_growth] C4=_se[lannual_growth] D4=`e(N_clust)' E4=`e(N)'

putexcel set tables_and_figures/tableA8.xlsx, modify
reghdfe fe0y lfe0qqar if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A4 = "10-year bond" B4=_b[lfe0qqar] C4=_se[lfe0qqar] D4=`e(N_clust)' E4=`e(N)'

**************************************************************************************************
* 									PGDP
**************************************************************************************************
insheet using empirics/raw_data/Dactualsyoy.csv, comma clear
rename year year_vintage
gen year = year_vintage -1 
tsset year 
rename yoy annual_growth
keep year annual_growth
gen lannual_growth = l.annual_growth
save empirics/processed_data/Dactualsannual.dta, replace

insheet using empirics/raw_data/Dlastyear.csv, comma clear
gen date_vintage = yq(year,quarter)
format date_vintage %tq
rename date_vintage date
format date %tq
keep date year levelly
tsset date
save empirics/processed_data/Dactualslastyearannual.dta, replace

insheet using empirics/raw_data/AnnualpredictionDef.csv, comma clear
gen date = yq(year,quarter)
format date %tq
rename fc annual_forecast
keep date year id annual_forecast
save empirics/processed_data/Annualprediction_pgdp.dta, replace

use empirics/processed_data/datindiv, clear
keep if macrovar=="PGDP"
drop if date>yq(2019,4)

gen error=0
replace error=1 if date==yq(1985,1) | date==yq(1986,1) | date==yq(1990,1)
gen gdpgnp=0
replace gdpgnp=1 if date==yq(1992,1)
gen chwgt=0
replace chwgt=1 if date==yq(1996,1)
gen basechg=0
replace basechg=1 if date==yq(1976,1) | date==yq(1986,1) | date==yq(1992,1) | date==yq(1996,1) | date==yq(1999,4) | date==yq(2004,1) | date==yq(2009,3) | date==yq(2013,3) | date==yq(2018,3)
gen smallsample=0
replace smallsample=1 if date==yq(1990,2)
gen flags=0
replace flags=1 if error==1|gdpgnp==1|smallsample==1|basechg==1

merge 1:1 id date using empirics/processed_data/Annualprediction_pgdp.dta
keep if _merge==3
drop _merge 
merge m:1 date using empirics/processed_data/Dactualslastyearannual.dta, nogen
xtset id date
merge m:1 year using empirics/processed_data/Dactualsannual.dta, nogen
xtset id date

foreach x of varlist h1 h2 hA hB {
	gen `x'_w = `x'
	summ `x', d
	replace `x'_w = . if `x'< (r(p50)-5*(r(p75)-r(p25))) | `x'> (r(p50) + 5*(r(p75)-r(p25)))
}
replace annual_forecast =. if hA==.

gen fe0y = annual_growth - annual_forecast
gen f1y = (hB_w/hA_w -1)*100 
gen fr0y2 = annual_forecast - l4.f1y
gen fr0y = .
replace fr0y = annual_forecast - l.annual_forecast if quarter>1
replace fr0y = annual_forecast - l.f1y if quarter==1
	
gen f0qqar = .
gen f0qq=.
	replace f0qqar = ((h2/h1)^4-1)*100
	replace f0qq=((1+f0qqar/100)^0.25-1)*100

gen fe0qqar = act_rt - f0qqar
gen lfe0qqar = l.fe0qqar

gen flag_annual = 0
replace flag_annual = 1 if date<yq(1981,3)

bysort id (date): gen agemax=_N
gen flag_age = 0
replace flag_age = 1 if agemax<10

putexcel set tables_and_figures/tableA6.xlsx, modify
reghdfe fe0y fr0y if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A5 = "GDP Deflator" B5=_b[fr0y] C5=_se[fr0y] D5=`e(N_clust)' E5=`e(N)'

putexcel set tables_and_figures/tableA7.xlsx, modify
reghdfe fe0y lannual_growth if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A5 = "GDP Deflator" B5=_b[lannual_growth] C5=_se[lannual_growth] D5=`e(N_clust)' E5=`e(N)'

putexcel set tables_and_figures/tableA8.xlsx, modify
reghdfe fe0y lfe0qqar if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A5 = "GDP Deflator" B5=_b[lfe0qqar] C5=_se[lfe0qqar] D5=`e(N_clust)' E5=`e(N)'


**************************************************************************************************
* 									NGDP
**************************************************************************************************
insheet using empirics/raw_data/NGDPactualsyoy.csv, comma clear
rename year year_vintage
gen year = year_vintage -1 
tsset year 
rename yoy annual_growth
keep year annual_growth
gen lannual_growth = l.annual_growth
save empirics/processed_data/NGDPactualsannual.dta, replace

insheet using empirics/raw_data/NGDPlastyear.csv, comma clear
gen date_vintage = yq(year,quarter)
format date_vintage %tq
rename date_vintage date
format date %tq
keep date year levelly
tsset date
save empirics/processed_data/NGDPactualslastyearannual.dta, replace

use empirics/processed_data/datindiv, clear
keep if macrovar=="NGDP"
drop if date>yq(2019,4)

gen error=0
replace error=1 if date==yq(1985,1) | date==yq(1986,1) | date==yq(1990,1)
gen gdpgnp=0
replace gdpgnp=1 if date==yq(1992,1)
gen chwgt=0
replace chwgt=1 if date==yq(1996,1)
gen basechg=0
replace basechg=1 if date==yq(1976,1) | date==yq(1986,1) | date==yq(1992,1) | date==yq(1996,1) | date==yq(1999,4) | date==yq(2004,1) | date==yq(2009,3) | date==yq(2013,3) | date==yq(2018,3)
gen smallsample=0
replace smallsample=1 if date==yq(1990,2)
gen flags=0
replace flags=1 if error==1|gdpgnp==1|smallsample==1|basechg==1

merge m:1 date using empirics/processed_data/NGDPactualslastyearannual.dta, nogen
xtset id date
merge m:1 year using empirics/processed_data/NGDPactualsannual.dta, nogen
xtset id date

foreach x of varlist h1 h2 hA hB {

gen `x'_w = `x'
summ `x', d
replace `x'_w = . if `x'< (r(p50)-5*(r(p75)-r(p25))) | `x'> (r(p50) + 5*(r(p75)-r(p25)))

}

gen annual_forecast = (hA_w/levelly-1)*100
replace annual_forecast =. if hA==.

gen f0qqar = .
gen f0qq=.
	replace f0qqar = ((h2/h1)^4-1)*100
	replace f0qq=((1+f0qqar/100)^0.25-1)*100

gen fe0y = annual_growth - annual_forecast
gen f1y = (hB_w/hA_w -1)*100 
gen fr0y = .
replace fr0y = annual_forecast - l.annual_forecast if quarter>1
replace fr0y = annual_forecast - l.f1y if quarter==1

gen fe0qqar = act_rt - f0qqar
gen lfe0qqar = l.fe0qqar

gen flag_annual = 0
replace flag_annual = 1 if date<yq(1981,3)

bysort id (date): gen agemax=_N
gen flag_age = 0
replace flag_age = 1 if agemax<10


putexcel set tables_and_figures/tableA6.xlsx, modify
reghdfe fe0y fr0y if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A6 = "Nominal GDP" B6=_b[fr0y] C6=_se[fr0y] D6=`e(N_clust)' E6=`e(N)'

putexcel set tables_and_figures/tableA7.xlsx, modify
reghdfe fe0y lannual_growth if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A6 = "Nominal GDP" B6=_b[lannual_growth] C6=_se[lannual_growth] D6=`e(N_clust)' E6=`e(N)'

putexcel set tables_and_figures/tableA8.xlsx, modify
reghdfe fe0y lfe0qqar if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A6 = "Nominal GDP" B6=_b[lfe0qqar] C6=_se[lfe0qqar] D6=`e(N_clust)' E6=`e(N)'



**************************************************************************************************
* 									RCON
**************************************************************************************************
insheet using empirics/raw_data/RCONactualsyoy.csv, comma clear
rename year year_vintage
gen year = year_vintage -1 
tsset year 
rename yoy annual_growth
keep year annual_growth
gen lannual_growth = l.annual_growth
save empirics/processed_data/RCONactualsannual.dta, replace

insheet using empirics/raw_data/RCONlastyear.csv, comma clear
gen date_vintage = yq(year,quarter)
format date_vintage %tq
rename date_vintage date
format date %tq
keep date year levelly
tsset date
save empirics/processed_data/RCONactualslastyearannual.dta, replace

use empirics/processed_data/datindiv, clear
keep if macrovar=="RCONSUM"
drop if date>yq(2019,4)

gen error=0
replace error=1 if date==yq(1985,1) | date==yq(1986,1) | date==yq(1990,1)
gen gdpgnp=0
replace gdpgnp=1 if date==yq(1992,1)
gen chwgt=0
replace chwgt=1 if date==yq(1996,1)
gen basechg=0
replace basechg=1 if date==yq(1976,1) | date==yq(1986,1) | date==yq(1992,1) | date==yq(1996,1) | date==yq(1999,4) | date==yq(2004,1) | date==yq(2009,3) | date==yq(2013,3) | date==yq(2018,3)
gen smallsample=0
replace smallsample=1 if date==yq(1990,2)
gen flags=0
replace flags=1 if error==1|gdpgnp==1|smallsample==1|basechg==1

merge m:1 date using empirics/processed_data/RCONactualslastyearannual.dta, nogen
xtset id date
merge m:1 year using empirics/processed_data/RCONactualsannual.dta, nogen
xtset id date

foreach x of varlist h1 h2 hA hB {

gen `x'_w = `x'
summ `x', d
replace `x'_w = . if `x'< (r(p50)-5*(r(p75)-r(p25))) | `x'> (r(p50) + 5*(r(p75)-r(p25)))

}

gen annual_forecast = (hA_w/levelly-1)*100
replace annual_forecast =. if hA_w==.
gen fe0y = annual_growth - annual_forecast
gen f1y = (hB_w/hA_w -1)*100 
gen fr0y2 = annual_forecast - l4.f1y
gen fr0y = .
replace fr0y = annual_forecast - l.annual_forecast if quarter>1
replace fr0y = annual_forecast - l.f1y if quarter==1


gen f0qqar = ((h2_w/h1_w)^4-1)*100
gen fe0qqar = act_rt - f0qqar
gen lfe0qqar = l.fe0qqar

gen flag_annual = 0
replace flag_annual = 1 if date<yq(1981,3)

drop if flag_annual==1 
drop if error==1

bysort id (date): gen agemax=_N
gen flag_age = 0
replace flag_age = 1 if agemax<10

putexcel set tables_and_figures/tableA6.xlsx, modify
reghdfe fe0y fr0y if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A7 = "Real consumption expenditures" B7=_b[fr0y] C7=_se[fr0y] D7=`e(N_clust)' E7=`e(N)'

putexcel set tables_and_figures/tableA7.xlsx, modify
reghdfe fe0y lannual_growth if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A7 = "Real consumption expenditures" B7=_b[lannual_growth] C7=_se[lannual_growth] D7=`e(N_clust)' E7=`e(N)'

putexcel set tables_and_figures/tableA8.xlsx, modify
reghdfe fe0y lfe0qqar if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A7 = "Real consumption expenditures" B7=_b[lfe0qqar] C7=_se[lfe0qqar] D7=`e(N_clust)' E7=`e(N)'


**************************************************************************************************
* 									RFED
**************************************************************************************************

insheet using empirics/raw_data/FEDGOVactualsyoy.csv, comma clear
rename year year_vintage
gen year = year_vintage -1 
tsset year 
rename yoy annual_growth
keep year annual_growth
gen lannual_growth = l.annual_growth
save empirics/processed_data/FEDGOVactualsannual.dta, replace

insheet using empirics/raw_data/FEDGOVlastyear.csv, comma clear
gen date_vintage = yq(year,quarter)
format date_vintage %tq
rename date_vintage date
format date %tq
keep date year levelly
tsset date
save empirics/processed_data/FEDGOVactualslastyearannual.dta, replace

use empirics/processed_data/datindiv, clear
keep if macrovar=="RFEDGOV"
drop if date>yq(2019,4)

gen error=0
replace error=1 if date==yq(1985,1) | date==yq(1986,1) | date==yq(1990,1)
gen gdpgnp=0
replace gdpgnp=1 if date==yq(1992,1)
gen chwgt=0
replace chwgt=1 if date==yq(1996,1)
gen basechg=0
replace basechg=1 if date==yq(1976,1) | date==yq(1986,1) | date==yq(1992,1) | date==yq(1996,1) | date==yq(1999,4) | date==yq(2004,1) | date==yq(2009,3) | date==yq(2013,3) | date==yq(2018,3)
gen smallsample=0
replace smallsample=1 if date==yq(1990,2)
gen flags=0
replace flags=1 if error==1|gdpgnp==1|smallsample==1|basechg==1


merge m:1 date using empirics/processed_data/FEDGOVactualslastyearannual.dta, nogen
xtset id date
merge m:1 year using empirics/processed_data/FEDGOVactualsannual.dta, nogen
xtset id date

foreach x of varlist h1 h2 hA hB {

gen `x'_w = `x'
summ `x', d
replace `x'_w = . if `x'< (r(p50)-5*(r(p75)-r(p25))) | `x'> (r(p50) + 5*(r(p75)-r(p25)))

}
gen annual_forecast = (hA_w/levelly-1)*100
replace annual_forecast=. if hA_w==.

gen f0qqar = ((h2_w/h1_w)^4-1)*100

gen fe0y = annual_growth - annual_forecast
gen f1y = (hB_w/hA_w -1)*100 
gen fr0y = .
replace fr0y = annual_forecast - l.annual_forecast if quarter>1
replace fr0y = annual_forecast - l.f1y if quarter==1

gen fe0qqar = act_rt - f0qqar
gen lfe0qqar = l.fe0qqar

gen flag_annual = 0
replace flag_annual = 1 if date<yq(1981,3)


bysort id (date): gen agemax=_N
gen flag_age = 0
replace flag_age = 1 if agemax<10


putexcel set tables_and_figures/tableA6.xlsx, modify
reghdfe fe0y fr0y if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A8 = "Real federal government spending" B8=_b[fr0y] C8=_se[fr0y] D8=`e(N_clust)' E8=`e(N)'

putexcel set tables_and_figures/tableA7.xlsx, modify
reghdfe fe0y lannual_growth if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A8 = "Real federal government spending" B8=_b[lannual_growth] C8=_se[lannual_growth] D8=`e(N_clust)' E8=`e(N)'

putexcel set tables_and_figures/tableA8.xlsx, modify
reghdfe fe0y lfe0qqar if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A8 = "Real federal government spending" B8=_b[lfe0qqar] C8=_se[lfe0qqar] D8=`e(N_clust)' E8=`e(N)'

**************************************************************************************************
* 									RSL
**************************************************************************************************

insheet using empirics/raw_data/LOCGOVactualsyoy.csv, comma clear
rename year year_vintage
gen year = year_vintage -1 
tsset year 
rename yoy annual_growth
keep year annual_growth
gen lannual_growth = l.annual_growth
save empirics/processed_data/LOCGOVactualsannual.dta, replace

insheet using empirics/raw_data/LOCGOVlastyear.csv, comma clear
gen date_vintage = yq(year,quarter)
format date_vintage %tq
rename date_vintage date
format date %tq
keep date year levelly
tsset date
save empirics/processed_data/LOCGOVactualslastyearannual.dta, replace

use empirics/processed_data/datindiv, clear
keep if macrovar=="RSLGOV"
drop if date>yq(2019,4)

gen error=0
replace error=1 if date==yq(1985,1) | date==yq(1986,1) | date==yq(1990,1)
gen gdpgnp=0
replace gdpgnp=1 if date==yq(1992,1)
gen chwgt=0
replace chwgt=1 if date==yq(1996,1)
gen basechg=0
replace basechg=1 if date==yq(1976,1) | date==yq(1986,1) | date==yq(1992,1) | date==yq(1996,1) | date==yq(1999,4) | date==yq(2004,1) | date==yq(2009,3) | date==yq(2013,3) | date==yq(2018,3)
gen smallsample=0
replace smallsample=1 if date==yq(1990,2)
gen flags=0
replace flags=1 if error==1|gdpgnp==1|smallsample==1|basechg==1


merge m:1 date using empirics/processed_data/LOCGOVactualslastyearannual.dta, nogen
xtset id date
merge m:1 year using empirics/processed_data/LOCGOVactualsannual.dta, nogen
xtset id date
foreach x of varlist h1 h2 hA hB {

gen `x'_w = `x'
summ `x', d
replace `x'_w = . if `x'< (r(p50)-5*(r(p75)-r(p25))) | `x'> (r(p50) + 5*(r(p75)-r(p25)))

}
gen annual_forecast = (hA_w/levelly-1)*100
replace annual_forecast =. if hA==.


gen fe0y = annual_growth - annual_forecast
gen f1y = (hB/hA -1)*100 
gen fr0y = .
replace fr0y = annual_forecast - l.annual_forecast if quarter>1
replace fr0y = annual_forecast - l.f1y if quarter==1

gen f0qqar = ((h2_w/h1_w)^4-1)*100
gen fe0qqar = act_rt - f0qqar
gen lfe0qqar = l.fe0qqar

gen flag_annual = 0
replace flag_annual = 1 if date<yq(1981,3)


bysort id (date): gen agemax=_N
gen flag_age = 0
replace flag_age = 1 if agemax<10


putexcel set tables_and_figures/tableA6.xlsx, modify
reghdfe fe0y fr0y if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A9 = "Real state & local government spending" B9=_b[fr0y] C9=_se[fr0y] D9=`e(N_clust)' E9=`e(N)'

putexcel set tables_and_figures/tableA7.xlsx, modify
reghdfe fe0y lannual_growth if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A9 = "Real state & local government spending" B9=_b[lannual_growth] C9=_se[lannual_growth] D9=`e(N_clust)' E9=`e(N)'

putexcel set tables_and_figures/tableA8.xlsx, modify
reghdfe fe0y lfe0qqar if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A9 = "Real state & local government spending" B9=_b[lfe0qqar] C9=_se[lfe0qqar] D9=`e(N_clust)' E9=`e(N)'

**************************************************************************************************
* 									RRES
**************************************************************************************************

insheet using empirics/raw_data/RESIDactualsyoy.csv, comma clear
rename year year_vintage
gen year = year_vintage -1 
tsset year 
rename yoy annual_growth
keep year annual_growth
gen lannual_growth = l.annual_growth
save empirics/processed_data/RESIDactualsannual.dta, replace

insheet using empirics/raw_data/RESIDlastyear.csv, comma clear
gen date_vintage = yq(year,quarter)
format date_vintage %tq
rename date_vintage date
format date %tq
keep date year levelly
tsset date
save empirics/processed_data/RESIDactualslastyearannual.dta, replace


use empirics/processed_data/datindiv, clear
keep if macrovar=="RRESINV"
drop if date>yq(2019,4)

gen error=0
replace error=1 if date==yq(1985,1) | date==yq(1986,1) | date==yq(1990,1)
gen gdpgnp=0
replace gdpgnp=1 if date==yq(1992,1)
gen chwgt=0
replace chwgt=1 if date==yq(1996,1)
gen basechg=0
replace basechg=1 if date==yq(1976,1) | date==yq(1986,1) | date==yq(1992,1) | date==yq(1996,1) | date==yq(1999,4) | date==yq(2004,1) | date==yq(2009,3) | date==yq(2013,3) | date==yq(2018,3)
gen smallsample=0
replace smallsample=1 if date==yq(1990,2)
gen flags=0
replace flags=1 if error==1|gdpgnp==1|smallsample==1|basechg==1

merge m:1 date using empirics/processed_data/RESIDactualslastyearannual.dta, nogen
xtset id date
merge m:1 year using empirics/processed_data/RESIDactualsannual.dta, nogen
xtset id date

foreach x of varlist h1 h2 hA hB {

gen `x'_w = `x'
summ `x', d
replace `x'_w = . if `x'< (r(p50)-5*(r(p75)-r(p25))) | `x'> (r(p50) + 5*(r(p75)-r(p25)))

}
gen annual_forecast = (hA/levelly-1)*100
replace annual_forecast =. if hA==.
	
gen fe0y = annual_growth - annual_forecast
gen f1y = (hB_w/hA_w -1)*100 
gen fr0y = .
replace fr0y = annual_forecast - l.annual_forecast if quarter>1
replace fr0y = annual_forecast - l.f1y if quarter==1

gen f0qqar = ((h2_w/h1_w)^4-1)*100
gen fe0qqar = act_rt - f0qqar
gen lfe0qqar = l.fe0qqar

gen flag_annual = 0
replace flag_annual = 1 if date<yq(1981,3)


bysort id (date): gen agemax=_N
gen flag_age = 0
replace flag_age = 1 if agemax<10

putexcel set tables_and_figures/tableA6.xlsx, modify
reghdfe fe0y fr0y if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A10 = "Real residential investment" B10=_b[fr0y] C10=_se[fr0y] D10=`e(N_clust)' E10=`e(N)'

putexcel set tables_and_figures/tableA7.xlsx, modify
reghdfe fe0y lannual_growth if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A10 = "Real residential investment" B10=_b[lannual_growth] C10=_se[lannual_growth] D10=`e(N_clust)' E10=`e(N)'

putexcel set tables_and_figures/tableA8.xlsx, modify
reghdfe fe0y lfe0qqar if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A10 = "Real residential investment" B10=_b[lfe0qqar] C10=_se[lfe0qqar] D10=`e(N_clust)' E10=`e(N)'

**************************************************************************************************
* 									RNRES
**************************************************************************************************

insheet using empirics/raw_data/NONRESIDactualsyoy.csv, comma clear
rename year year_vintage
gen year = year_vintage -1 
tsset year 
rename yoy annual_growth
keep year annual_growth
gen lannual_growth = l.annual_growth
save empirics/processed_data/NONRESIDactualsannual.dta, replace

insheet using empirics/raw_data/NONRESIDlastyear.csv, comma clear
gen date_vintage = yq(year,quarter)
format date_vintage %tq
rename date_vintage date
format date %tq
keep date year levelly
tsset date
save empirics/processed_data/NONRESIDactualslastyearannual.dta, replace

use empirics/processed_data/datindiv, clear
keep if macrovar=="RNRESIN"
drop if date>yq(2019,4)

gen error=0
replace error=1 if date==yq(1985,1) | date==yq(1986,1) | date==yq(1990,1)
gen gdpgnp=0
replace gdpgnp=1 if date==yq(1992,1)
gen chwgt=0
replace chwgt=1 if date==yq(1996,1)
gen basechg=0
replace basechg=1 if date==yq(1976,1) | date==yq(1986,1) | date==yq(1992,1) | date==yq(1996,1) | date==yq(1999,4) | date==yq(2004,1) | date==yq(2009,3) | date==yq(2013,3) | date==yq(2018,3)
gen smallsample=0
replace smallsample=1 if date==yq(1990,2)
gen flags=0
replace flags=1 if error==1|gdpgnp==1|smallsample==1|basechg==1

merge m:1 date using empirics/processed_data/NONRESIDactualslastyearannual.dta, nogen
xtset id date
merge m:1 year using empirics/processed_data/NONRESIDactualsannual.dta, nogen
xtset id date
foreach x of varlist h1 h2 hA hB {

gen `x'_w = `x'
summ `x', d
replace `x'_w = . if `x'< (r(p50)-5*(r(p75)-r(p25))) | `x'> (r(p50) + 5*(r(p75)-r(p25)))

}
gen annual_forecast = (hA_w/levelly-1)*100

replace annual_forecast =. if hA==.

gen fe0y = annual_growth - annual_forecast
gen f1y = (hB_w/hA_w -1)*100 
gen fr0y = .
replace fr0y = annual_forecast - l.annual_forecast if quarter>1
replace fr0y = annual_forecast - l.f1y if quarter==1

gen f0qqar = ((h2_w/h1_w)^4-1)*100
gen fe0qqar = act_rt - f0qqar
gen lfe0qqar = l.fe0qqar

gen flag_annual = 0
replace flag_annual = 1 if date<yq(1981,3)

bysort id (date): gen agemax=_N
gen flag_age = 0
replace flag_age = 1 if agemax<10


putexcel set tables_and_figures/tableA6.xlsx, modify
reghdfe fe0y fr0y if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A11 = "Real residential investment" B11=_b[fr0y] C11=_se[fr0y] D11=`e(N_clust)' E11=`e(N)'

putexcel set tables_and_figures/tableA7.xlsx, modify
reghdfe fe0y lannual_growth if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A11 = "Real residential investment" B11=_b[lannual_growth] C11=_se[lannual_growth] D11=`e(N_clust)' E11=`e(N)'

putexcel set tables_and_figures/tableA8.xlsx, modify
reghdfe fe0y lfe0qqar if flag_annual==0 & flags==0 & flag_age==0, noa cluster(id date)
putexcel A11 = "Real residential investment" B11=_b[lfe0qqar] C11=_se[lfe0qqar] D11=`e(N_clust)' E11=`e(N)'









