
local sheetlist NGDP RGDP PGDP INDPROD UNEMP EMP TBILL BOND HOUSING RCONSUM RNRESIN CPI RRESINV RFEDGOV TBOND RSLGOV

* Cleaning
local sheetlist NGDP RGDP PGDP UNEMP INDPROD EMP TBILL BOND HOUSING RCONSUM RNRESIN CPI RRESINV RFEDGOV TBOND RSLGOV
foreach i of local sheetlist {	
	import excel empirics/raw_data/SPFmicrodata.xlsx, sheet(`i') firstrow clear
	rename YEAR year
	rename QUARTER quarter
	rename ID id
	gen str macrovar = "`i'"
	
	replace INDUSTRY="" if INDUSTRY=="#N/A"
	replace `i'1="" if `i'1=="#N/A"
	replace `i'2="" if `i'2=="#N/A"
	replace `i'3="" if `i'3=="#N/A"
	replace `i'4="" if `i'4=="#N/A"
	replace `i'5="" if `i'5=="#N/A"
	replace `i'6="" if `i'6=="#N/A"
	replace `i'A="" if `i'A=="#N/A"
	replace `i'B="" if `i'B=="#N/A"
	
	destring, replace
	rename `i'* h*
	
	* Generating dates
	sort id year
	gen date = yq(year,quarter)
	format date %tq
	drop year quarter
	order id date, first
	xtset id date 

	save empirics/processed_data/spf_`i'.dta, replace
}

use empirics/processed_data/spf_NGDP.dta, clear
local looplist RGDP PGDP UNEMP INDPROD EMP TBILL BOND HOUSING RCONSUM RNRESIN CPI RRESINV RFEDGOV TBOND RSLGOV
foreach j of local looplist {
append using empirics/processed_data/spf_`j'.dta
}
save empirics/processed_data/spf_indiv.dta, replace
local looplist2 NGDP RGDP PGDP UNEMP INDPROD EMP TBILL BOND HOUSING RCONSUM RNRESIN CPI RRESINV RFEDGOV TBOND RSLGOV
foreach j of local looplist2 {
erase empirics/processed_data/spf_`j'.dta
}

* Now gathering realized data
clear all
import excel empirics/raw_data/realizations.xlsx, firstrow clear
gen date=yq(year,quarter)
format date %tq
encode macrovar, gen(macrovar_num)
xtset macrovar_num date
save empirics/processed_data/realizations.dta, replace

* Merging panel of forecasts with TS of relizations
use empirics/processed_data/spf_indiv.dta, clear
merge m:1 date macrovar using empirics/processed_data/realizations.dta
keep if _merge==3
drop _merge

* Declaring panel at forecaster-variable by year level
egen id2=group(id macrovar)
xtset id2 date

save empirics/processed_data/datindiv.dta, replace
