
%% ------------------------------------ RGDP ------------------------------------ %%
PARAMHAT = [0.441 1.842 1.289 0.934 0.999 0.581];
[bgms_rgdp, bgms_sd_rgdp] = SMM_bgms(PARAMHAT);
%% ------------------------------------ NGDP ------------------------------------ %%
PARAMHAT = [0.4692 2.3445 1.1832 0.8741 0.7515 0.6186];
[bgms_ngdp,bgms_sd_ngdp] = SMM_bgms(PARAMHAT);
%% ------------------------------------ RCON ------------------------------------ %%
PARAMHAT = [0.3823 1.6212 1.7367 0.4726 0.9963 0.4905];
[bgms_rcon, bgms_sd_rcon] = SMM_bgms(PARAMHAT);
%% ------------------------------------ PGDP ------------------------------------ %%
PARAMHAT = [0.5851 1.0412 0.9503 0.5656 1.000 0.5518];
[bgms_pgdp, bgms_sd_pgdp] = SMM_bgms(PARAMHAT);
%% ------------------------------------ RRES ------------------------------------ %%
PARAMHAT = [0.5888 10.3817 8.5646 3.7068 0.8730 0.3990];
[bgms_rres,bgms_sd_rres] = SMM_bgms(PARAMHAT);
%% ------------------------------------ RNRES ------------------------------------ %%
PARAMHAT = [0.6878 6.1263 4.8904 4.5164 0.9983 0.4314];
[bgms_rnres,bgms_sd_rnres] = SMM_bgms(PARAMHAT);
%% ------------------------------------ RFEDGOV ------------------------------------ %%
PARAMHAT = [0.4002    5.6275    5.9052    4.4412    1.0000    0.2438];
[bgms_rfed,bgms_sd_rfed] = SMM_bgms(PARAMHAT);
%% ------------------------------------ RSLGOV ------------------------------------ %%
PARAMHAT = [0.4147 2.2844 0.5061 3.4228 0.8568 0.4468];
[bgms_rsl,bgms_sd_rsl] = SMM_bgms(PARAMHAT);
%% ------------------------------------ UE ------------------------------------ %%
PARAMHAT = [0.999 0.206 0.0001 0.001 0.7989 1.000];
[bgms_ue,bgms_sd_ue] = SMM_bgms(PARAMHAT);
%% ------------------------------------ TBOND ------------------------------------ %%
PARAMHAT = [0.1936 0.3261 0.001 0.001 0.9991 0.6488];
[bgms_tbond,bgms_sd_tbond] = SMM_bgms(PARAMHAT);
%% ------------------------------------ TBILL ------------------------------------ %%
PARAMHAT = [0.4955    0.3151    0.0059    0.0023    0.9379    0.7039];
[bgms_tbill,bgms_sd_tbill] = SMM_bgms(PARAMHAT);
%% ------------------------------------ RGDP (WSJ) ------------------------------------ %%
PARAMHAT = [0.2054 1.3507 0.001 0.0047 0.4197 0.4163];
[bgms_rgdp_wsj, bgms_sd_rgdp_wsj] = SMM_bgms_WSJ_BBG(PARAMHAT);
%% ------------------------------------ RGDP (BBG) ------------------------------------ %%
PARAMHAT = [0.7168 1.2015 0.8993 0.3225 0.7505 0.3696];
[bgms_rgdp_bbg, bgms_sd_rgdp_bbg] = SMM_bgms_WSJ_BBG(PARAMHAT);


%% Collect simulated coefficients and print Table 7
bgms    = [bgms_rgdp bgms_ngdp bgms_rcon bgms_pgdp bgms_rres bgms_rnres bgms_rfed bgms_rsl bgms_ue ...
            bgms_tbond bgms_tbill bgms_rgdp_wsj bgms_rgdp_bbg];
bgms_sd = [bgms_sd_rgdp bgms_sd_ngdp bgms_sd_rcon bgms_sd_pgdp bgms_sd_rres bgms_sd_rnres bgms_sd_rfed ...
            bgms_sd_rsl bgms_sd_ue bgms_sd_tbond bgms_sd_tbill bgms_sd_rgdp_wsj bgms_sd_rgdp_bbg];

round([bgms ;bgms_sd]',3);

bgms_dat = [-0.157 -0.308 -0.268 -0.510 -0.108 -0.031 -0.512 -0.494 0.312 -0.114 0.134 -0.443 -0.587];
bgms_se  = [0.070 0.060 0.061 0.062 0.088 0.111 0.068 0.086 0.108 0.065 0.076 0.237 0.111];


vars_str=["Real GDP" "Nominal GDP" "Real consumer spending" "GDP deflator" "Real residential investment" ...
    "Real nonresidential investment" "Real federal spending" "Real state/local spending" "Unemployment" ...
    "Ten year bond" "3-month bill" "Real GDP (BBG)" "Real GDP (WSJ)"];

disp('%%%%%%%%%%%%%%%%%%')
disp('Table 7')
disp('')
disp([ ["" "Model" "" "Data" ""] ; vars_str'  round([bgms ;bgms_sd]',3) round([bgms_dat ;bgms_se]',3)])
disp(' ')

