function [bgms_mn,bgms_sd]=SMM_bgms_WSJ_BBG(xval)

Nsim=200;%number of simulations
N=141;%number of forecasters 
T=244;%number of (reference) periods 
burn=50;%burn-in length


% Draw shocks
shocks=[];
rng(5301);
v=randn(Nsim,N,T);%private signal noise
e=randn(Nsim,T+burn);%public signal noise
w=randn(Nsim,T+burn);%state innovations
%for probabilties, draw U[0,1] and compare to (p,q)
pdraw=rand(Nsim,N,T);
qdraw=rand(Nsim,N,T);
    
momvec = NaN(Nsim,1);
for simct=1:Nsim
    shocks.v        = squeeze(v(simct,:,:));
    shocks.e        = squeeze(e(simct,:));
    shocks.w        = squeeze(w(simct,:));
    shocks.pdraw    = squeeze(pdraw(simct,:,:));
    shocks.qdraw    = squeeze(qdraw(simct,:,:));
    momvec(simct) = SMM_bgms_fnc_WSJ_BBG(xval,shocks,N,T,burn);
end

bgms_mn = squeeze(mean(momvec));
bgms_sd = squeeze(std(momvec));

end
