function [momvec, kvec] = SMM_nontarget(xval,shocks,N,T,burn)
%% Set some parameters
H=8;%number of horizons 
Ns=2;%number of state variables in LGSS model
%% Read in xval
mu=2.4;
rho=xval(1);
sigw=xval(2);
sige=xval(3);
sigv=xval(4);
q=xval(5);
p=xval(6);
%% Generate DGP and signals
s=zeros(1,T+burn);
s(1,1)=mu;
for t=2:T+burn
    s(1,t) = (1-rho)*mu + rho*s(1,t-1) + sigw*shocks.w(1,t);
end
x=s+sige*shocks.e;
xm1=x;
s=s(1,burn+1:end);
x=x(1,burn+1:end);
xm1=xm1(1,burn:end-1);
y=repmat(s,[N,1]) + sigv*shocks.v;
qdraw=shocks.qdraw<q;
pdraw=shocks.pdraw<p;
%% Run Kalman filter
MU = [mu*(1-rho);0];
A = [rho 0; 1 0]; 
B = [sigw;0];
C = eye(Ns);
D = [sigv 0; 0 sige];

v_s = sigw^2/(1-rho^2);
s0=mu*ones(2,1); 
P0=[v_s rho*v_s; rho*v_s v_s] ;

%arrays that store KF predictions
stt=NaN(N,T,H);
sttm1=NaN(N,T,H);

% Loop for Kalman filter
for n=1:N
    
	t=1;
	%predict
    sbm1 = MU + A*s0;
    Pbm1 = A*P0*A' + B*B';
    %update
    z=[y(n,t);xm1(t)];
    K = Pbm1*C'/(C*Pbm1*C'+D*D');
    sb = sbm1 + K*(z-C*sbm1);
    Pb = (eye(Ns)-K*C)*Pbm1;
    %store forecasts
    sttm1(n,t,1) = sbm1(1);
    stt(n,t,1) = sb(1);
    for h=2:H
        sttm1(n,t,h) = (1-rho)*mu + rho*sttm1(n,t,h-1);
        stt(n,t,h) = (1-rho)*mu + rho*stt(n,t,h-1);
    end
    
    %Now do the rest
	for t=2:T
        %predict
        sbm1 = MU + A*sb;
	    Pbm1 = A*Pb*A' + B*B';
       
        %update
        z=[y(n,t);xm1(1,t)];
        K = Pbm1*C'/(C*Pbm1*C'+D*D');
        sb = sbm1 + K*(z-C*sbm1);
        Pb = (eye(Ns)-K*C)*Pbm1;
            
        %store forecasts 
        sttm1(n,t,1) = sbm1(1);
        stt(n,t,1) = sb(1);
        for h=2:H
            sttm1(n,t,h) = (1-rho)*mu + rho*sttm1(n,t,h-1);
            stt(n,t,h) = (1-rho)*mu + rho*stt(n,t,h-1);
        end

	end %t
        
end %n
%% Now build reported forecasts, updates
xhat = NaN(N,T,H);
xhat1a=NaN(N,T);
xhat2a=NaN(N,T);

%initialize
xhat(:,1:4,:) = stt(:,1:4,:);
xhat1a(:,4) = mean(stt(:,1,1:4),3);
xhat2a(:,4) = mean(stt(:,1,5:8),3);

for n=1:N
    for t=5:T
        if mod(t,4)==1
            xhataimplied=mean(stt(n,t,1:4));
            xhatimplied2a=mean(stt(n,t,5:8));
        end
        if mod(t,4)==2
            xhataimplied=(x(1,t-1) + sum(stt(n,t,1:3)) )/4;
            xhatimplied2a=mean(stt(n,t,4:7));
        end
        if mod(t,4)==3
            xhataimplied=(x(1,t-2) + x(1,t-1) + sum(stt(n,t,1:2)) )/4;
            xhatimplied2a=mean(stt(n,t,3:6));
        end
        if mod(t,4)==0
            xhataimplied=(x(1,t-3) + x(1,t-2) + x(1,t-1) + stt(n,t,1) )/4;
            xhatimplied2a=mean(stt(n,t,2:5));
        end
        
        if qdraw(n,t)==0 && pdraw(n,t)==0 %Case 1: No updating
            
            xhat(n,t,1:H-1) = xhat(n,t-1,2:H);
            if mod(t,4)==0
                xhat1a(n,t) = xhat2a(n,t-1);
                xhat2a(n,t) = NaN;
            else
                xhat1a(n,t) = xhat1a(n,t-1);
                xhat2a(n,t) = xhat2a(n,t-1);
            end
            
        elseif qdraw(n,t)==1 && pdraw(n,t)==0 %Case 2: Update Q not A
            if mod(t,4)==1
                xhat(n,t,1:4) = stt(n,t,1:4) + (xhat1a(n,t-1) - xhataimplied); 
                xhat(n,t,5) = stt(n,t,5) + (xhat2a(n,t-1) - xhatimplied2a);
            end
            if mod(t,4)==2
                xhat(n,t,1:3) = stt(n,t,1:3) + (xhat1a(n,t-1) - xhataimplied); 
                xhat(n,t,4:5) = stt(n,t,4:5) + (xhat2a(n,t-1) - xhatimplied2a); 
            end
            if mod(t,4)==3
                xhat(n,t,1:2) = stt(n,t,1:2) + (xhat1a(n,t-1) - xhataimplied); 
                xhat(n,t,3:5) = stt(n,t,3:5) + (xhat2a(n,t-1) - xhatimplied2a); 
            end
            if mod(t,4)==0
                xhat(n,t,1) = stt(n,t,1) + (xhat1a(n,t-1) - xhataimplied); 
                xhat(n,t,2:5) = stt(n,t,2:5) + (xhat2a(n,t-1) - xhatimplied2a); 
            end
            
            if mod(t,4)==0
                xhat1a(n,t) = xhat2a(n,t-1);
                xhat2a(n,t) = NaN;
            else
                xhat1a(n,t) = xhat1a(n,t-1);
                xhat2a(n,t) = xhat2a(n,t-1);
            end
            
        elseif qdraw(n,t)==0 && pdraw(n,t)==1 %Case 3: Update A not Q
            xhat(n,t,1:H-1) = xhat(n,t-1,2:H);
            if mod(t,4)==1 %if in Q1, yesterday's FE doesn't figure into A today
                xhat1a(n,t) = xhat1a(n,t-1);
            else %else if in Q2-Q4, yesterday's FE does figure into A today
                xhat1a(n,t) = xhat1a(n,t-1) + (1/4)*(xm1(1,t) - xhat(n,t-1,1));
            end
            xhat2a(n,t) = xhat2a(n,t-1);
    
        elseif qdraw(n,t)==1 && pdraw(n,t)==1 %Case 4: Update both
            xhat(n,t,:) = stt(n,t,:);
            xhat1a(n,t) = xhataimplied;
            xhat2a(n,t) = xhatimplied2a;  
        end
        
    end %t
end %n

%% Construct non-targeted moments
%clearing the first initialization periods 
%and getting the timing right across vars

fr0 = xhat(:,5:end,1) - xhat(:,4:end-1,2);
fr1 = xhat(:,5:end-1,2) - xhat(:,4:end-2,3);
fr2 = xhat(:,5:end-2,3) - xhat(:,4:end-3,4);
fr3 = xhat(:,5:end-3,4) - xhat(:,4:end-4,5);

fr1m1 = xhat(:,4:end-1,2) - xhat(:,3:end-2,3);
fr2m1 = xhat(:,4:end-2,3) - xhat(:,3:end-3,4);
fr3m1 = xhat(:,4:end-3,4) - xhat(:,3:end-4,5);

fe0 = repmat(x(5:end),[N,1]) - xhat(:,5:end,1);
fe1 = repmat(x(6:end),[N,1]) - xhat(:,5:end-1,2);
fe2 = repmat(x(7:end),[N,1]) - xhat(:,5:end-2,3);
fe3 = repmat(x(8:end),[N,1]) - xhat(:,5:end-3,4);

%converting to y/y
xhatqq=((1+xhat./100).^0.25-1).*100;
fyy = ((1+xhatqq(:,:,1)./100).*(1+xhatqq(:,:,2)./100).*(1+xhatqq(:,:,3)./100).*(1+xhatqq(:,:,4)./100)-1)*100;
fyym1 = ((1+xhatqq(:,:,2)./100).*(1+xhatqq(:,:,3)./100).*(1+xhatqq(:,:,4)./100).*(1+xhatqq(:,:,5)./100)-1)*100;
xqq = ((1+x./100).^0.25-1).*100;
xyy = ((1+xqq(1:end-4)./100).*(1+xqq(2:end-3)./100).*(1+xqq(3:end-2)./100).*(1+xqq(4:end-1)./100)-1)*100;
fey = repmat(xyy(2:end),[N,1]) - fyy(:,2:end-4);
fry = fyy(:,2:end-4) - fyym1(:,1:end-5);
feykw = repmat(xyy(5:end),[N,1]) - fyy(:,5:end-4);
xyykw = xyy(1:end-4);


% Individual level regressions 
%FE vs. FR
tmp1=nancov(fe0,fr0);
tmp2=nancov(fe1,fr1);
tmp3=nancov(fe2,fr2); 
tmp4=nancov(fe3,fr3); 

%FE persistence, individual
tmpr=nancov(fe0(:,2:end),fe0(:,1:end-1));

% Kohlhas/Walther 
tmpkw=nancov(feykw,repmat(xyykw,[N,1]));

% BGMS
tmpbgms=nancov(fey,fry);

%Revision autocorrrelation
tmpg1=nancov(fr0,fr1m1);
tmpg2=nancov(fr1,fr2m1);
tmpg3=nancov(fr2,fr3m1);

% Consensus level regressions
%FE vs. FR
tmp1mn=nancov(nanmean(fe0),nanmean(fr0));
tmp2mn=nancov(nanmean(fe1),nanmean(fr1));
tmp3mn=nancov(nanmean(fe2),nanmean(fr2));
tmp4mn=nancov(nanmean(fe3),nanmean(fr3));

%FE persistence
tmprmn=nancov(nanmean(fe0(:,2:end)),nanmean(fe0(:,1:end-1)));

%CG
tmpcg=nancov(nanmean(fey),nanmean(fry));

%KW
tmpkwmn=nancov(nanmean(feykw),xyykw);

%Revision autocorrelation
tmpgmn1=nancov(nanmean(fr0),nanmean(fr1m1));
tmpgmn2=nancov(nanmean(fr1),nanmean(fr2m1));
tmpgmn3=nancov(nanmean(fr2),nanmean(fr3m1));

%Offsetting regression
Y=reshape(fr3,[numel(fr3),1]); 
X=[ones(numel(fr3),1) reshape(fr2(:,1:end-1),[numel(fr3),1]) reshape(fr1(:,1:end-2),[numel(fr3),1]) reshape(fr0(:,1:end-3),[numel(fr3),1])];
tmpoffb=mvregress(X,Y);

%% Fill moment vector
momvec=NaN(1,23);
kvec=NaN(2,1);

    momvec(1) = tmp1(1,2)/tmp1(2,2);%beta1
    momvec(2) = tmp2(1,2)/tmp2(2,2);%beta2
    momvec(3) = tmp3(1,2)/tmp3(2,2);%beta3
    momvec(4) = tmp4(1,2)/tmp4(2,2);%beta4
    
    momvec(5) = tmpg1(1,2)/tmpg1(2,2);%gama1
    momvec(6) = tmpg2(1,2)/tmpg2(2,2);%gama2
    momvec(7) = tmpg3(1,2)/tmpg3(2,2);%gama3
    
    momvec(8) = tmpbgms(1,2)/tmpbgms(2,2);%BGMS
    momvec(9) = tmpkw(1,2)/tmpkw(2,2);%Kohlhas/Walther
    momvec(10) = tmpr(1,2)/tmpr(2,2);%FE persistence
    
    momvec(11) = tmp1mn(1,2)/tmp1mn(2,2);%beta1mn
    momvec(12) = tmp2mn(1,2)/tmp2mn(2,2);%beta2mn
    momvec(13) = tmp3mn(1,2)/tmp3mn(2,2);%beta3mn
    momvec(14) = tmp4mn(1,2)/tmp4mn(2,2);%beta4mn
    
    momvec(15) = tmpgmn1(1,2)/tmpgmn1(2,2);%gama1mn
    momvec(16) = tmpgmn2(1,2)/tmpgmn2(2,2);%gama2mn 
    momvec(17) = tmpgmn3(1,2)/tmpgmn3(2,2);%gama3mn
    
    momvec(18) = tmpcg(1,2)/tmpcg(2,2);%CG
    momvec(19) = tmpkwmn(1,2)/tmpkwmn(2,2);%KW
    momvec(20) = tmprmn(1,2)/tmprmn(2,2);%FE persistence (mean)

    momvec(21) = tmpoffb(2);
    momvec(22) = tmpoffb(3);
    momvec(23) = tmpoffb(4);
    
    kvec(1) = K(1,1);
    kvec(2) = K(1,2);
end
