close all; clear all; clc;

replication_root      = pwd;
figure_folder         = fullfile(replication_root,'tables_and_figures');
function_folder       = fullfile(replication_root,'model','functions');
processed_data_folder = fullfile(replication_root,'model','processed_data');

addpath(function_folder);
addpath(figure_folder);
addpath(processed_data_folder);

%% --  Tables & figures from main text 

% Figures 2 and 3
run model/Figure2_Figure3.m

% Figure 4
run model/Figure4.m

% Table 5, Table 6, and Table 8
run model/Table5_Table6_Table8.m

% Table 7
run model/Table7.m

%% -- Supplementary materials

% Table D1
run model/TableD1.m 

% Figure D1 and Table D2
run model/FigureD1_TableD2.m

% Table D3
run model/TableD3.m

% Table D4
run model/TableD4.m

% Table D5
run model/TableD5.m

% Table D6
run model/TableD6.m

% Table D7
run model/TableD7.m

